/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalSystemNodeDialog;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectExternalTaskDialog
extends SelectExternalSystemNodeDialog {
    private static final Class<? extends ExternalSystemNode>[] NODE_CLASSES = (Class[])ContainerUtil.ar((Object[])new Class[]{ProjectNode.class, ModuleNode.class, TaskNode.class});
    private Pair<String, TaskData> myResult;

    public SelectExternalTaskDialog(@NotNull ProjectSystemId systemId, Project project) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/ui/SelectExternalTaskDialog", "<init>"));
        }
        super(systemId, project, String.format("Choose %s Task", systemId.getReadableName()), NODE_CLASSES, null);
        this.groupTasks = Boolean.FALSE;
        this.useTasksNode = Boolean.FALSE;
        this.init();
    }

    protected void doOKAction() {
        SimpleNode node = this.getSelectedNode();
        if (node instanceof NullNode) {
            node = null;
        }
        this.myResult = node instanceof TaskNode ? Pair.create((Object)((TaskNode)node).getModuleOwnerName(), ((TaskNode)node).getData()) : null;
        super.doOKAction();
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myResult = null;
    }

    @Override
    protected void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/SelectExternalTaskDialog", "handleDoubleClickOrEnter"));
        }
        if (node instanceof ProjectNode) {
            this.doOKAction();
        }
    }

    public Pair<String, TaskData> getResult() {
        return this.myResult;
    }

    @Override
    protected Object customizeProjectsTreeRoot(Object rootElement) {
        if (rootElement instanceof ExternalSystemNode && ((ExternalSystemNode)rootElement).getChildCount() == 1) {
            ExternalSystemNode node = ((ExternalSystemNode)rootElement).getChildren()[0];
            return node instanceof ProjectNode && ((ProjectNode)node).isSingleModuleProject() ? rootElement : node;
        }
        return rootElement;
    }
}

