/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class ExternalSystemSelectProjectDataToImportAction
extends ExternalSystemAction {
    public void actionPerformed(AnActionEvent e) {
        ExternalProjectInfo projectInfo;
        Project project = this.getProject(e);
        ProjectSystemId projectSystemId = this.getSystemId(e);
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)selectedNodes);
        if (externalSystemNode == null) {
            projectInfo = (ExternalProjectInfo)ContainerUtil.getFirstItem(ProjectDataManager.getInstance().getExternalProjectsData(project, projectSystemId));
        } else {
            ProjectNode projectNode;
            ProjectNode projectNode2 = projectNode = externalSystemNode instanceof ProjectNode ? (ProjectNode)externalSystemNode : externalSystemNode.findParent(ProjectNode.class);
            assert (projectNode != null);
            ProjectData projectData = (ProjectData)projectNode.getData();
            assert (projectData != null);
            projectInfo = ProjectDataManager.getInstance().getExternalProjectData(project, projectSystemId, projectData.getLinkedExternalProjectPath());
        }
        if (projectInfo != null) {
            ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(project, projectInfo, externalSystemNode != null ? externalSystemNode.getData() : null);
            dialog.showAndGet();
        }
    }
}

