/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actions.BackspaceAction;
import com.intellij.openapi.editor.actions.CutAction;
import com.intellij.openapi.editor.actions.DeleteAction;
import com.intellij.openapi.editor.actions.DeleteToLineEndAction;
import com.intellij.openapi.editor.actions.DeleteToLineStartAction;
import com.intellij.openapi.editor.actions.DeleteToWordEndAction;
import com.intellij.openapi.editor.actions.DeleteToWordEndInDifferentHumpsModeAction;
import com.intellij.openapi.editor.actions.DeleteToWordStartAction;
import com.intellij.openapi.editor.actions.DeleteToWordStartInDifferentHumpsModeAction;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DelayMeter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ImmediatePainter {
    private static final Set<Character> KEY_CHARS_TO_SKIP = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\'')));
    private static final Set<Character> DOCUMENT_CHARS_TO_SKIP = new HashSet<Character>(Arrays.asList(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\'')));
    private static final Set<Class> IMMEDIATE_EDITING_ACTIONS = new HashSet<Class>(Arrays.asList(BackspaceAction.class, DeleteAction.class, DeleteToWordStartAction.class, DeleteToWordEndAction.class, DeleteToWordStartInDifferentHumpsModeAction.class, DeleteToWordEndInDifferentHumpsModeAction.class, DeleteToLineStartAction.class, DeleteToLineEndAction.class, CutAction.class, PasteAction.class));
    public static final String ZERO_LATENCY_TYPING_KEY = "editor.zero.latency.typing";
    public static final String ZERO_LATENCY_TYPING_DEBUG_KEY = "editor.zero.latency.typing.debug";
    public static final int DEBUG_PAUSE_DURATION = 1000;
    public static final String TYPING_LATENCY_STATS_KEY = "editor.typing.latency.stats";
    private static final int TYPING_STATS_SAMPLE_SIZE = 50;
    private static final boolean VIM_PLUGIN_LOADED = ImmediatePainter.isPluginLoaded("IdeaVIM");
    private Rectangle myOldArea = new Rectangle(0, 0, 0, 0);
    private Rectangle myOldTailArea = new Rectangle(0, 0, 0, 0);
    private boolean myImmediateEditingInProgress;
    private final EditorImpl myEditor;
    private int myCharsTyped;
    private final DelayMeter myTypingLatencyMeter = new DelayMeter();
    private boolean myZeroLatencyTypingWasEnabled = ImmediatePainter.isZeroLatencyTypingEnabled();

    ImmediatePainter(EditorImpl editor) {
        this.myEditor = editor;
        AnActionListener.Adapter actionListener = new AnActionListener.Adapter(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (ImmediatePainter.isZeroLatencyTypingEnabled() && IMMEDIATE_EDITING_ACTIONS.contains(action.getClass()) && (action.getClass() != PasteAction.class || !ImmediatePainter.this.getSelectionModel().hasSelection())) {
                    ImmediatePainter.this.myImmediateEditingInProgress = true;
                }
            }

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (ImmediatePainter.isZeroLatencyTypingEnabled()) {
                    ImmediatePainter.this.myImmediateEditingInProgress = false;
                }
            }
        };
        ActionManager.getInstance().addAnActionListener((AnActionListener)actionListener, editor.getDisposable());
    }

    protected Document getDocument() {
        return this.myEditor.getDocument();
    }

    protected SelectionModel getSelectionModel() {
        return this.myEditor.getSelectionModel();
    }

    protected EditorHighlighter getHighlighter() {
        return this.myEditor.getHighlighter();
    }

    protected CaretModel getCaretModel() {
        return this.myEditor.getCaretModel();
    }

    protected EditorColorsScheme getColorsScheme() {
        return this.myEditor.getColorsScheme();
    }

    protected EditorComponentImpl getContentComponent() {
        return this.myEditor.getContentComponent();
    }

    public void paintCharacter(Graphics g, char c) {
        if (ImmediatePainter.isTypingLatencyStatsEnabled()) {
            if (this.myZeroLatencyTypingWasEnabled != ImmediatePainter.isZeroLatencyTypingEnabled()) {
                this.resetTypingLatencyStats();
                this.myZeroLatencyTypingWasEnabled = ImmediatePainter.isZeroLatencyTypingEnabled();
            }
            this.myTypingLatencyMeter.registerStart();
        }
        if (ImmediatePainter.isZeroLatencyTypingEnabled() && this.getDocument().isWritable() && !this.myEditor.isViewer() && this.canPaintImmediately(c)) {
            for (Caret caret : this.getCaretModel().getAllCarets()) {
                this.paintImmediately(g, caret.getOffset(), c, this.myEditor.isInsertMode());
            }
            if (ImmediatePainter.isTypingLatencyStatsEnabled()) {
                this.myTypingLatencyMeter.registerFinish();
            }
        }
        if (ImmediatePainter.isTypingLatencyStatsEnabled()) {
            ++this.myCharsTyped;
            if (this.myCharsTyped == 50) {
                String stats = "Zero-latency: " + ImmediatePainter.isZeroLatencyTypingEnabled() + "; " + this.myTypingLatencyMeter.stat();
                this.printToEventLog(stats);
                this.resetTypingLatencyStats();
            }
        }
    }

    private void printToEventLog(String message) {
        NotificationGroup group = NotificationGroup.logOnlyGroup((String)"typing-delay-stats");
        Notification notification = group.createNotification(message, NotificationType.INFORMATION);
        notification.setImportant(true);
        notification.notify(this.myEditor.getProject());
        notification.hideBalloon();
    }

    private void resetTypingLatencyStats() {
        this.myCharsTyped = 0;
        this.myTypingLatencyMeter.reset();
    }

    public void afterPainting() {
        if (ImmediatePainter.isTypingLatencyStatsEnabled()) {
            this.myTypingLatencyMeter.registerFinish();
        }
    }

    public void beforeUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/ImmediatePainter", "beforeUpdate"));
        }
        if (ImmediatePainter.isZeroLatencyTypingEnabled() && this.myImmediateEditingInProgress && this.canPaintImmediately(e)) {
            int offset = e.getOffset();
            int length = e.getOldLength();
            this.myOldArea = this.lineRectangleBetween(offset, offset + length);
            this.myOldTailArea = this.lineRectangleBetween(offset + length, this.getDocument().getLineEndOffset(this.getDocument().getLineNumber(offset)));
            if (this.myOldTailArea.isEmpty()) {
                this.myOldTailArea.width += EditorUtil.getSpaceWidth(0, this.myEditor);
            }
        }
    }

    public void paintUpdate(Graphics g, @NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/ImmediatePainter", "paintUpdate"));
        }
        if (ImmediatePainter.isZeroLatencyTypingEnabled() && this.myImmediateEditingInProgress && this.canPaintImmediately(e)) {
            this.paintImmediately(g, e);
        }
    }

    private static boolean isZeroLatencyTypingEnabled() {
        return !VIM_PLUGIN_LOADED && Registry.is((String)ZERO_LATENCY_TYPING_KEY);
    }

    private static boolean isZeroLatencyTypingDebugEnabled() {
        return Registry.is((String)ZERO_LATENCY_TYPING_DEBUG_KEY);
    }

    private static boolean isTypingLatencyStatsEnabled() {
        return Registry.is((String)TYPING_LATENCY_STATS_KEY);
    }

    private static boolean isPluginLoaded(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/editor/impl/ImmediatePainter", "isPluginLoaded"));
        }
        PluginId pluginId = PluginId.findId((String[])new String[]{id});
        if (pluginId == null) {
            return false;
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        if (plugin == null) {
            return false;
        }
        return plugin.isEnabled();
    }

    private boolean canPaintImmediately(char c) {
        return this.getDocument() instanceof DocumentImpl && this.getHighlighter() instanceof LexerEditorHighlighter && !this.getSelectionModel().hasSelection() && this.arePositionsWithinDocument(this.getCaretModel().getAllCarets()) && ImmediatePainter.areVisualLinesUnique(this.getCaretModel().getAllCarets()) && !this.isInplaceRenamerActive() && !KEY_CHARS_TO_SKIP.contains(Character.valueOf(c));
    }

    private static boolean areVisualLinesUnique(List<Caret> carets) {
        if (carets.size() > 1) {
            TIntHashSet lines = new TIntHashSet(carets.size());
            for (Caret caret : carets) {
                if (lines.add(caret.getVisualLineStart())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean arePositionsWithinDocument(List<Caret> carets) {
        for (Caret caret : carets) {
            if (caret.getLogicalPosition().compareTo(this.myEditor.offsetToLogicalPosition(caret.getOffset())) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isInplaceRenamerActive() {
        Key key = Key.findKeyByName((String)"EditorInplaceRenamer");
        return key != null && key.isIn((UserDataHolder)this.myEditor);
    }

    private void paintImmediately(Graphics g, int offset, char c, boolean insert) {
        Rectangle tailArea;
        int charWidth;
        if (g == null) {
            return;
        }
        TextAttributes attributes = ((LexerEditorHighlighter)this.getHighlighter()).getAttributes((DocumentImpl)this.getDocument(), offset, c);
        int fontType = attributes.getFontType();
        FontInfo fontInfo = EditorUtil.fontForChar(c, attributes.getFontType(), this.myEditor);
        Font font = fontInfo.getFont();
        FontMetrics fontMetrics = this.myEditor.getFontMetrics(fontType);
        int delta = charWidth = fontMetrics.charWidth(c);
        if (!insert && offset < this.getDocument().getTextLength()) {
            delta -= fontMetrics.charWidth(this.getDocument().getCharsSequence().charAt(offset));
        }
        if ((tailArea = this.lineRectangleBetween(offset, this.getDocument().getLineEndOffset(this.myEditor.offsetToLogicalLine(offset)))).isEmpty()) {
            tailArea.width += EditorUtil.getSpaceWidth(fontType, this.myEditor);
        }
        Color background = attributes.getBackgroundColor() == null ? this.getCaretRowBackground() : attributes.getBackgroundColor();
        Rectangle newArea = this.lineRectangleBetween(offset, offset);
        newArea.width += charWidth;
        String newText = Character.toString(c);
        Point point = newArea.getLocation();
        int ascent = this.myEditor.getAscent();
        Color foreground = attributes.getForegroundColor() == null ? this.myEditor.getForegroundColor() : attributes.getForegroundColor();
        EditorUIUtil.setupAntialiasing(g);
        if (delta != 0) {
            ImmediatePainter.shift(g, tailArea, delta);
        }
        ImmediatePainter.fill(g, newArea, background);
        ImmediatePainter.print(g, newText, point, ascent, font, foreground);
        Toolkit.getDefaultToolkit().sync();
        if (ImmediatePainter.isZeroLatencyTypingDebugEnabled()) {
            ImmediatePainter.pause();
        }
    }

    private static void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean canPaintImmediately(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/ImmediatePainter", "canPaintImmediately"));
        }
        return this.getDocument() instanceof DocumentImpl && !this.isInplaceRenamerActive() && StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') == -1 && StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') == -1 && (e.getNewLength() != 1 || !DOCUMENT_CHARS_TO_SKIP.contains(Character.valueOf(e.getNewFragment().charAt(0))));
    }

    private void paintImmediately(Graphics g, @NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/ImmediatePainter", "paintImmediately"));
        }
        if (g == null) {
            return;
        }
        int offset = e.getOffset();
        String newText = e.getNewFragment().toString();
        Rectangle newArea = this.lineRectangleBetween(offset, offset + newText.length());
        int delta = newArea.width - this.myOldArea.width;
        Color background = this.getCaretRowBackground();
        if (delta != 0) {
            EditorImpl.CaretRectangle[] caretRectangles;
            if (delta < 0 && (caretRectangles = this.myEditor.getCaretCursor().getCaretLocations(true)) != null) {
                for (EditorImpl.CaretRectangle it : caretRectangles) {
                    Rectangle r = this.toRectangle(it);
                    if (!this.myOldArea.contains(r) || newArea.contains(r)) continue;
                    this.myEditor.getCaretCursor().paintAt(g, it.myPoint.x - delta, it.myPoint.y, it.myWidth, it.myCaret);
                }
            }
            ImmediatePainter.shift(g, this.myOldTailArea, delta);
            if (delta < 0) {
                Rectangle remainingArea = new Rectangle(this.myOldTailArea.x + this.myOldTailArea.width + delta, this.myOldTailArea.y, -delta, this.myOldTailArea.height);
                ImmediatePainter.fill(g, remainingArea, background);
            }
        }
        if (!newArea.isEmpty()) {
            TextAttributes attributes = this.getHighlighter().createIterator(offset).getTextAttributes();
            Point point = newArea.getLocation();
            int ascent = this.myEditor.getAscent();
            FontInfo fontInfo = EditorUtil.fontForChar(newText.charAt(0), attributes.getFontType(), this.myEditor);
            Font font = fontInfo.getFont();
            Color foreground = attributes.getForegroundColor() == null ? this.myEditor.getForegroundColor() : attributes.getForegroundColor();
            EditorUIUtil.setupAntialiasing(g);
            ImmediatePainter.fill(g, newArea, background);
            ImmediatePainter.print(g, newText, point, ascent, font, foreground);
        }
        Toolkit.getDefaultToolkit().sync();
        if (ImmediatePainter.isZeroLatencyTypingDebugEnabled()) {
            ImmediatePainter.pause();
        }
    }

    @NotNull
    private Rectangle lineRectangleBetween(int begin, int end) {
        Point p1 = this.myEditor.offsetToXY(begin, false);
        Point p2 = this.myEditor.offsetToXY(end, false);
        int x2 = p1.y == p2.y ? p2.x : Math.max(p1.x, this.getContentComponent().getWidth() - this.myEditor.getVerticalScrollBar().getWidth());
        Rectangle rectangle = new Rectangle(p1.x, p1.y, x2 - p1.x, this.myEditor.getLineHeight());
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ImmediatePainter", "lineRectangleBetween"));
        }
        return rectangle;
    }

    @NotNull
    private Rectangle toRectangle(@NotNull EditorImpl.CaretRectangle caretRectangle) {
        if (caretRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretRectangle", "com/intellij/openapi/editor/impl/ImmediatePainter", "toRectangle"));
        }
        Point p = caretRectangle.myPoint;
        Rectangle rectangle = new Rectangle(p.x, p.y, caretRectangle.myWidth, this.myEditor.getLineHeight());
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ImmediatePainter", "toRectangle"));
        }
        return rectangle;
    }

    @NotNull
    private Color getCaretRowBackground() {
        Color color = this.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        Color color2 = color == null ? this.myEditor.getBackgroundColor() : color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ImmediatePainter", "getCaretRowBackground"));
        }
        return color2;
    }

    private static void shift(@NotNull Graphics g, @NotNull Rectangle r, int delta) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/ImmediatePainter", "shift"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/editor/impl/ImmediatePainter", "shift"));
        }
        g.copyArea(r.x, r.y, r.width, r.height, delta, 0);
    }

    private static void fill(@NotNull Graphics g, @NotNull Rectangle r, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/ImmediatePainter", "fill"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/editor/impl/ImmediatePainter", "fill"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/ImmediatePainter", "fill"));
        }
        g.setColor(color);
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    private static void print(@NotNull Graphics g, @NotNull String text, @NotNull Point point, int ascent, @NotNull Font font, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/ImmediatePainter", "print"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/ImmediatePainter", "print"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/editor/impl/ImmediatePainter", "print"));
        }
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/openapi/editor/impl/ImmediatePainter", "print"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/ImmediatePainter", "print"));
        }
        g.setFont(font);
        g.setColor(color);
        g.drawString(text, point.x, point.y + ascent);
    }
}

