/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.SystemHealthMonitor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.BackspaceAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    @NonNls
    public static final String ACTION_ELEMENT_NAME = "action";
    @NonNls
    public static final String GROUP_ELEMENT_NAME = "group";
    @NonNls
    public static final String ACTIONS_ELEMENT_NAME = "actions";
    @NonNls
    public static final String CLASS_ATTR_NAME = "class";
    @NonNls
    public static final String ID_ATTR_NAME = "id";
    @NonNls
    public static final String INTERNAL_ATTR_NAME = "internal";
    @NonNls
    public static final String ICON_ATTR_NAME = "icon";
    @NonNls
    public static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    @NonNls
    public static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    @NonNls
    public static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    @NonNls
    public static final String DESCRIPTION = "description";
    @NonNls
    public static final String TEXT_ATTR_NAME = "text";
    @NonNls
    public static final String POPUP_ATTR_NAME = "popup";
    @NonNls
    public static final String COMPACT_ATTR_NAME = "compact";
    @NonNls
    public static final String SEPARATOR_ELEMENT_NAME = "separator";
    @NonNls
    public static final String REFERENCE_ELEMENT_NAME = "reference";
    @NonNls
    public static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    @NonNls
    public static final String GROUPID_ATTR_NAME = "group-id";
    @NonNls
    public static final String ANCHOR_ELEMENT_NAME = "anchor";
    @NonNls
    public static final String FIRST = "first";
    @NonNls
    public static final String LAST = "last";
    @NonNls
    public static final String BEFORE = "before";
    @NonNls
    public static final String AFTER = "after";
    @NonNls
    public static final String SECONDARY = "secondary";
    @NonNls
    public static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    @NonNls
    public static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    @NonNls
    public static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    @NonNls
    public static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    @NonNls
    public static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    @NonNls
    public static final String KEYMAP_ATTR_NAME = "keymap";
    @NonNls
    public static final String KEYSTROKE_ATTR_NAME = "keystroke";
    @NonNls
    public static final String REF_ATTR_NAME = "ref";
    @NonNls
    public static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    @NonNls
    public static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    @NonNls
    public static final String OVERRIDES_ATTR_NAME = "overrides";
    @NonNls
    public static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    @NonNls
    public static final String PROJECT_TYPE = "project-type";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionManagerImpl");
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> myId2Action = new THashMap();
    private final Map<PluginId, THashSet<String>> myPlugin2Id = new THashMap();
    private final TObjectIntHashMap<String> myId2Index = new TObjectIntHashMap();
    private final Map<Object, String> myAction2Id = new THashMap();
    private final MultiMap<String, String> myId2GroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final KeymapManager myKeymapManager;
    private final DataManager myDataManager;
    private final List<ActionPopupMenuImpl> myPopups = new ArrayList<ActionPopupMenuImpl>();
    private final Map<AnAction, DataContext> myQueuedNotifications = new LinkedHashMap<AnAction, DataContext>();
    private final Map<AnAction, AnActionEvent> myQueuedNotificationsEvents = new LinkedHashMap<AnAction, AnActionEvent>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn = 0L;
    private Runnable myPreloadActionsRunnable;
    private boolean myTransparentOnlyUpdate;
    private int myActionsPreloaded = 0;
    private static final Map<Class<?>, Boolean> ourActionsExcludedFromTracking = new IdentityHashMap();

    ActionManagerImpl(KeymapManager keymapManager, DataManager dataManager) {
        this.myKeymapManager = keymapManager;
        this.myDataManager = dataManager;
        this.registerPluginActions();
    }

    static AnAction convertStub(ActionStub stub) {
        String iconPath;
        Object obj;
        String className = stub.getClassName();
        try {
            Class<?> aClass = Class.forName(className, true, stub.getLoader());
            obj = ReflectionUtil.newInstance(aClass);
        }
        catch (ClassNotFoundException e) {
            PluginId pluginId = stub.getPluginId();
            if (pluginId != null) {
                throw new PluginException("class with name \"" + className + "\" not found", (Throwable)e, pluginId);
            }
            throw new IllegalStateException("class with name \"" + className + "\" not found");
        }
        catch (UnsupportedClassVersionError e) {
            PluginId pluginId = stub.getPluginId();
            if (pluginId != null) {
                throw new PluginException((Throwable)e, pluginId);
            }
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            PluginId pluginId = stub.getPluginId();
            if (pluginId != null) {
                throw new PluginException("cannot create class \"" + className + "\"", (Throwable)e, pluginId);
            }
            throw new IllegalStateException("cannot create class \"" + className + "\"", e);
        }
        if (!(obj instanceof AnAction)) {
            throw new IllegalStateException("class with name '" + className + "' must be an instance of '" + AnAction.class.getName() + "'; got " + obj);
        }
        AnAction anAction = (AnAction)obj;
        stub.initAction(anAction);
        if (StringUtil.isNotEmpty((String)stub.getText())) {
            anAction.getTemplatePresentation().setText(stub.getText());
        }
        if ((iconPath = stub.getIconPath()) != null) {
            Class<?> actionClass = anAction.getClass();
            ActionManagerImpl.setIconFromClass(actionClass, actionClass.getClassLoader(), iconPath, anAction.getTemplatePresentation(), stub.getPluginId());
        }
        return anAction;
    }

    private static void processAbbreviationNode(Element e, String id) {
        String abbr = e.getAttributeValue(VALUE_ATTR_NAME);
        if (!StringUtil.isEmpty((String)abbr)) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id, true);
        }
    }

    @Nullable
    private static ResourceBundle getActionsResourceBundle(ClassLoader loader, IdeaPluginDescriptor plugin) {
        String resBundleName = plugin != null && !"com.intellij".equals(plugin.getPluginId().getIdString()) ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE;
        ResourceBundle bundle = null;
        if (resBundleName != null) {
            bundle = AbstractBundle.getResourceBundle((String)resBundleName, (ClassLoader)loader);
        }
        return bundle;
    }

    private static boolean isSecondary(Element element) {
        return "true".equalsIgnoreCase(element.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, @NotNull String className, @NotNull ClassLoader loader, @NotNull Presentation presentation, PluginId pluginId) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIcon"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIcon"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIcon"));
        }
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, loader);
            ActionManagerImpl.setIconFromClass(actionClass, loader, iconPath, presentation, pluginId);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
        catch (NoClassDefFoundError e) {
            LOG.error((Throwable)e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(final @NotNull Class actionClass, final @NotNull ClassLoader classLoader, final @NotNull String iconPath, @NotNull Presentation presentation, final PluginId pluginId) {
        if (actionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionClass", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIconFromClass"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIconFromClass"));
        }
        if (iconPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconPath", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIconFromClass"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "setIconFromClass"));
        }
        IconLoader.LazyIcon lazyIcon = new IconLoader.LazyIcon(){

            protected Icon compute() {
                Icon icon = IconLoader.findIcon((String)iconPath, (Class)actionClass, (boolean)true);
                if (icon == null) {
                    icon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
                if (icon == null) {
                    ActionManagerImpl.reportActionError(pluginId, "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
                }
                return icon;
            }

            public String toString() {
                return "LazyIcon@ActionManagerImpl (path: " + iconPath + ", action class: " + actionClass + ")";
            }
        };
        if (!Registry.is((String)"ide.lazyIconLoading")) {
            lazyIcon.load();
        }
        presentation.setIcon((Icon)lazyIcon);
    }

    private static String loadDescriptionForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(DESCRIPTION);
        if (bundle != null) {
            String key = elementType + "." + id + ".description";
            return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)(value == null ? "" : value), (Object[])new Object[0]);
        }
        return value;
    }

    private static String loadTextForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(TEXT_ATTR_NAME);
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id + "." + TEXT_ATTR_NAME), (String)(value == null ? "" : value), (Object[])new Object[0]);
    }

    public static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ANCHOR_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "checkRelativeToAction"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "checkRelativeToAction"));
        }
        if ((Anchor.BEFORE == anchor || Anchor.AFTER == anchor) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    public static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private static void processMouseShortcutNode(Element element, String actionId, PluginId pluginId) {
        MouseShortcut shortcut;
        String keystrokeString = element.getAttributeValue(KEYSTROKE_ATTR_NAME);
        if (keystrokeString == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = KeymapManager.getInstance().getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionError(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        String removeOption = element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME);
        if (Boolean.valueOf(removeOption).booleanValue()) {
            keymap.removeShortcut(actionId, (Shortcut)shortcut);
        } else {
            keymap.addShortcut(actionId, (Shortcut)shortcut);
        }
    }

    private static void assertActionIsGroupOrStub(AnAction action) {
        if (!(action instanceof ActionGroup || action instanceof ActionStub || action instanceof ChameleonAction)) {
            LOG.error("Action : " + action + "; class: " + action.getClass());
        }
    }

    private static void reportActionError(PluginId pluginId, @NonNls @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "reportActionError"));
        }
        if (pluginId == null) {
            LOG.error(message);
        } else {
            LOG.error((Throwable)new PluginException(message, null, pluginId));
        }
    }

    private static void reportActionWarning(PluginId pluginId, @NonNls @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "reportActionWarning"));
        }
        if (pluginId == null) {
            LOG.warn(message);
        } else {
            LOG.warn(new PluginException(message, null, pluginId).getMessage());
        }
    }

    @NonNls
    private static String getPluginInfo(@Nullable PluginId id) {
        IdeaPluginDescriptor plugin;
        if (id != null && (plugin = PluginManager.getPlugin(id)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        return contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int delay, TimerListener listener) {
        this._addTimerListener(listener, false);
    }

    public void removeTimerListener(TimerListener listener) {
        this._removeTimerListener(listener, false);
    }

    public void addTransparentTimerListener(int delay, TimerListener listener) {
        this._addTimerListener(listener, true);
    }

    public void removeTransparentTimerListener(TimerListener listener) {
        this._removeTimerListener(listener, true);
    }

    private void _addTimerListener(TimerListener listener, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener, transparent);
    }

    private void _removeTimerListener(TimerListener listener, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.removeTimerListener(listener, transparent);
        }
    }

    public ActionPopupMenu createActionPopupMenu(String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GROUP_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "createActionPopupMenu"));
        }
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    public ActionPopupMenu createActionPopupMenu(String place, @NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GROUP_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "createActionPopupMenu"));
        }
        return new ActionPopupMenuImpl(place, group, this, null);
    }

    public ActionToolbar createActionToolbar(String place, @NotNull ActionGroup group, boolean horizontal) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GROUP_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "createActionToolbar"));
        }
        return this.createActionToolbar(place, group, horizontal, false);
    }

    public ActionToolbar createActionToolbar(String place, @NotNull ActionGroup group, boolean horizontal, boolean decorateButtons) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GROUP_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "createActionToolbar"));
        }
        return new ActionToolbarImpl(place, group, horizontal, decorateButtons, this.myDataManager, this, (KeymapManagerEx)this.myKeymapManager);
    }

    private void registerPluginActions() {
        IdeaPluginDescriptor[] plugins2;
        for (IdeaPluginDescriptor plugin : plugins2 = PluginManagerCore.getPlugins()) {
            List elementList;
            if (PluginManagerCore.shouldSkipPlugin(plugin) || (elementList = plugin.getActionsDescriptionElements()) == null) continue;
            for (Element e : elementList) {
                this.processActionsChildElement(plugin.getPluginClassLoader(), plugin.getPluginId(), e);
            }
        }
    }

    public AnAction getAction(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getAction"));
        }
        return this.getActionImpl(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnAction getActionImpl(String id, boolean canReturnStub) {
        Object object = this.myLock;
        synchronized (object) {
            AnAction action = this.myId2Action.get(id);
            if (!canReturnStub && action instanceof ActionStub) {
                action = this.convert((ActionStub)action);
            }
            return action;
        }
    }

    @NotNull
    private AnAction convert(@NotNull ActionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "convert"));
        }
        LOG.assertTrue(this.myAction2Id.containsKey(stub));
        this.myAction2Id.remove(stub);
        LOG.assertTrue(this.myId2Action.containsKey(stub.getId()));
        AnAction action = this.myId2Action.remove(stub.getId());
        LOG.assertTrue(action != null);
        LOG.assertTrue(action.equals(stub));
        AnAction anAction = ActionManagerImpl.convertStub(stub);
        this.myAction2Id.put(anAction, stub.getId());
        AnAction anAction2 = this.addToMap(stub.getId(), anAction, stub.getPluginId(), stub.getProjectType());
        if (anAction2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "convert"));
        }
        return anAction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTION_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getId"));
        }
        LOG.assertTrue(!(action instanceof ActionStub));
        Object object = this.myLock;
        synchronized (object) {
            return this.myAction2Id.get(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idPrefix", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getActionIds"));
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : this.myId2Action.keySet()) {
                if (!id.startsWith(idPrefix)) continue;
                idList.add(id);
            }
            return ArrayUtil.toStringArray(idList);
        }
    }

    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "isGroup"));
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    public JComponent createButtonToolbar(String actionPlace, @NotNull ActionGroup messageActionGroup) {
        if (messageActionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageActionGroup", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "createButtonToolbar"));
        }
        return new ButtonToolbarImpl(actionPlace, messageActionGroup, this.myDataManager, this);
    }

    public AnAction getActionOrStub(String id) {
        return this.getActionImpl(id, true);
    }

    @Nullable
    private AnAction processActionElement(Element element, ClassLoader loader, PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!ACTION_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "action element should have specified \"class\" attribute");
            return null;
        }
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null || id.isEmpty()) {
            id = StringUtil.getShortName((String)className);
        }
        if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id);
            return null;
        }
        String text = ActionManagerImpl.loadTextForElement(element, bundle, id, ACTION_ELEMENT_NAME);
        String iconPath = element.getAttributeValue(ICON_ATTR_NAME);
        if (text == null) {
            String message = "'text' attribute is mandatory (action ID=" + id + ";" + (plugin == null ? "" : " plugin path: " + plugin.getPath()) + ")";
            ActionManagerImpl.reportActionError(pluginId, message);
            return null;
        }
        String projectType = element.getAttributeValue(PROJECT_TYPE);
        ActionStub stub = new ActionStub(className, id, text, loader, pluginId, iconPath, projectType);
        Presentation presentation = stub.getTemplatePresentation();
        presentation.setText(text);
        presentation.setDescription(ActionManagerImpl.loadDescriptionForElement(element, bundle, id, ACTION_ELEMENT_NAME));
        for (Object o : element.getChildren()) {
            Element e = (Element)o;
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode((AnAction)stub, e, pluginId, ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                this.processKeyboardShortcutNode(e, id, pluginId);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processMouseShortcutNode(e, id, pluginId);
                continue;
            }
            if (ABBREVIATION_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processAbbreviationNode(e, id);
                continue;
            }
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        if (element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
            ((KeymapManagerEx)this.myKeymapManager).bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
        }
        this.registerOrReplaceActionInner(element, id, (AnAction)stub, pluginId);
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element, @NotNull String id, @NotNull AnAction action, @Nullable PluginId pluginId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerOrReplaceActionInner"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerOrReplaceActionInner"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTION_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerOrReplaceActionInner"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.valueOf(element.getAttributeValue(OVERRIDES_ATTR_NAME)).booleanValue()) {
                if (this.getActionOrStub(id) == null) {
                    throw new RuntimeException(element.getName() + " '" + id + "' doesn't override anything");
                }
                AnAction prev = this.replaceAction(id, action, pluginId);
                if (action instanceof DefaultActionGroup && prev instanceof DefaultActionGroup && Boolean.valueOf(element.getAttributeValue(KEEP_CONTENT_ATTR_NAME)).booleanValue()) {
                    ((DefaultActionGroup)action).copyFromGroup((DefaultActionGroup)prev);
                }
            } else {
                this.registerAction(id, action, pluginId, element.getAttributeValue(PROJECT_TYPE));
            }
        }
    }

    private AnAction processGroupElement(Element element, ClassLoader loader, PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String description;
            DefaultActionGroup group;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group = new DefaultCompactActionGroup();
            } else {
                Class<?> aClass = Class.forName(className, true, loader);
                Object obj = new ConstructorInjectionComponentAdapter((Object)className, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer());
                if (!(obj instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element.getChildren().size() != element.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                group = (ActionGroup)obj;
            }
            String id = element.getAttributeValue(ID_ATTR_NAME);
            if (id != null && id.isEmpty()) {
                ActionManagerImpl.reportActionError(pluginId, "ID of the group cannot be an empty string");
                return null;
            }
            if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id);
                return null;
            }
            if (id != null) {
                this.registerOrReplaceActionInner(element, id, (AnAction)group, pluginId);
            }
            Presentation presentation = group.getTemplatePresentation();
            String text = ActionManagerImpl.loadTextForElement(element, bundle, id, GROUP_ELEMENT_NAME);
            if (!StringUtil.isEmpty((String)text) || presentation.getText() == null) {
                presentation.setText(text);
            }
            if (!StringUtil.isEmpty((String)(description = ActionManagerImpl.loadDescriptionForElement(element, bundle, id, GROUP_ELEMENT_NAME))) || presentation.getDescription() == null) {
                presentation.setDescription(description);
            }
            ActionManagerImpl.setIcon(element.getAttributeValue(ICON_ATTR_NAME), className, loader, presentation, pluginId);
            String popup = element.getAttributeValue(POPUP_ATTR_NAME);
            if (popup != null) {
                group.setPopup(Boolean.valueOf(popup).booleanValue());
            }
            for (Object o : element.getChildren()) {
                AnAction action;
                Element child = (Element)o;
                String name = child.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action = this.processActionElement(child, loader, pluginId);
                    if (action == null) continue;
                    ActionManagerImpl.assertActionIsGroupOrStub(action);
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode(group, child, pluginId);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action = this.processGroupElement(child, loader, pluginId);
                    if (action == null) continue;
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group, child, pluginId, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action = this.processReferenceElement(child, pluginId);
                    if (action == null) continue;
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (ClassNotFoundException e) {
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
            return null;
        }
        catch (NoClassDefFoundError e) {
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + e.getMessage() + "\" not found");
            return null;
        }
        catch (UnsupportedClassVersionError e) {
            ActionManagerImpl.reportActionError(pluginId, "unsupported class version for " + className);
            return null;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            if (pluginId == null) {
                LOG.error(message, (Throwable)e);
            } else {
                LOG.error((Throwable)new PluginException(message, (Throwable)e, pluginId));
            }
            return null;
        }
    }

    private void processReferenceNode(Element element, PluginId pluginId) {
        AnAction action = this.processReferenceElement(element, pluginId);
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child.getName())) continue;
            this.processAddToGroupNode(action, child, pluginId, ActionManagerImpl.isSecondary(child));
        }
    }

    private void processAddToGroupNode(AnAction action, Element element, PluginId pluginId, boolean secondary) {
        if (!(action instanceof Separator)) {
            ActionManagerImpl.assertActionIsGroupOrStub(action);
        }
        String actionName = String.format("%s (%s)", action instanceof ActionStub ? ((ActionStub)action).getClassName() : action.getClass().getName(), action instanceof ActionStub ? ((ActionStub)action).getId() : this.myAction2Id.get(action));
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        AnAction parentGroup = this.getParentGroup(element.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor = ActionManagerImpl.parseAnchor(element.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor == null) {
            return;
        }
        String relativeToActionId = element.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner(parentGroup, action, new Constraints(anchor, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group, AnAction action, Constraints constraints, boolean secondary) {
        ((DefaultActionGroup)group).addAction(action, constraints, (ActionManager)this).setAsSecondary(secondary);
        this.myId2GroupId.putValue((Object)this.myAction2Id.get(action), (Object)this.myAction2Id.get(group));
    }

    @Nullable
    public AnAction getParentGroup(String groupId, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId == null || groupId.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + parentGroup.getClass());
            return null;
        }
        return parentGroup;
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, Element element, PluginId pluginId) {
        if (!SEPARATOR_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        Separator separator = Separator.getInstance();
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child, pluginId, ActionManagerImpl.isSecondary(child));
        }
    }

    private void processKeyboardShortcutNode(Element element, String actionId, PluginId pluginId) {
        String firstStrokeString = element.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME);
        if (firstStrokeString == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = this.myKeymapManager.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionWarning(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        String removeOption = element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME);
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        String replaceOption = element.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME);
        if (Boolean.valueOf(removeOption).booleanValue()) {
            keymap.removeShortcut(actionId, (Shortcut)shortcut);
        }
        if (Boolean.valueOf(replaceOption).booleanValue()) {
            keymap.removeAllActionShortcuts(actionId);
        }
        if (!Boolean.valueOf(removeOption).booleanValue()) {
            keymap.addShortcut(actionId, (Shortcut)shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String ref = element.getAttributeValue(REF_ATTR_NAME);
        if (ref == null) {
            ref = element.getAttributeValue(ID_ATTR_NAME);
        }
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action = this.getActionImpl(ref, true);
        if (action == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        ActionManagerImpl.assertActionIsGroupOrStub(action);
        return action;
    }

    private void processActionsChildElement(ClassLoader loader, PluginId pluginId, Element child) {
        String name = child.getName();
        if (ACTION_ELEMENT_NAME.equals(name)) {
            AnAction action = this.processActionElement(child, loader, pluginId);
            if (action != null) {
                ActionManagerImpl.assertActionIsGroupOrStub(action);
            }
        } else if (GROUP_ELEMENT_NAME.equals(name)) {
            this.processGroupElement(child, loader, pluginId);
        } else if (SEPARATOR_ELEMENT_NAME.equals(name)) {
            this.processSeparatorNode(null, child, pluginId);
        } else if (REFERENCE_ELEMENT_NAME.equals(name)) {
            this.processReferenceNode(child, pluginId);
        } else {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
        }
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTION_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerAction"));
        }
        this.registerAction(actionId, action, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId, @Nullable String projectType) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTION_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerAction"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action, pluginId, projectType) == null) {
                return;
            }
            if (this.myAction2Id.containsKey(action)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + this.myAction2Id.get(action) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Index.put((Object)actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put(action, actionId);
            if (pluginId != null && !(action instanceof ActionGroup)) {
                THashSet pluginActionIds = this.myPlugin2Id.get(pluginId);
                if (pluginActionIds == null) {
                    pluginActionIds = new THashSet();
                    this.myPlugin2Id.put(pluginId, (THashSet<String>)pluginActionIds);
                }
                pluginActionIds.add((Object)actionId);
            }
            action.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId, this.myKeymapManager), null);
        }
    }

    private AnAction addToMap(String actionId, AnAction action, PluginId pluginId, String projectType) {
        if (projectType != null || this.myId2Action.containsKey(actionId)) {
            return this.registerChameleon(actionId, action, pluginId, projectType);
        }
        this.myId2Action.put(actionId, action);
        return action;
    }

    private AnAction registerChameleon(String actionId, AnAction action, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.myId2Action.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action, type);
            this.myId2Action.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.myId2Action.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action, type);
        if (old != null) {
            ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action + "; Registered action is " + this.myId2Action.get(actionId) + ActionManagerImpl.getPluginInfo(pluginId));
            return null;
        }
        return chameleonAction;
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTION_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "registerAction"));
        }
        this.registerAction(actionId, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "unregisterAction"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey(actionId) && LOG.isDebugEnabled()) {
                LOG.debug("action with ID " + actionId + " wasn't registered");
                return;
            }
            AnAction oldValue = this.myId2Action.remove(actionId);
            this.myAction2Id.remove(oldValue);
            this.myId2Index.remove((Object)actionId);
            for (PluginId pluginName : this.myPlugin2Id.keySet()) {
                THashSet<String> pluginActions = this.myPlugin2Id.get(pluginName);
                if (pluginActions == null) continue;
                pluginActions.remove((Object)actionId);
            }
        }
    }

    @NotNull
    public String getComponentName() {
        if ("ActionManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getComponentName"));
        }
        return "ActionManager";
    }

    public Comparator<String> getRegistrationOrderComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                return ActionManagerImpl.this.myId2Index.get((Object)id1) - ActionManagerImpl.this.myId2Index.get((Object)id2);
            }
        };
    }

    @NotNull
    public String[] getPluginActions(PluginId pluginName) {
        if (this.myPlugin2Id.containsKey(pluginName)) {
            THashSet<String> pluginActions = this.myPlugin2Id.get(pluginName);
            String[] stringArray = ArrayUtil.toStringArray(pluginActions);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getPluginActions"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getPluginActions"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void addActionPopup(ActionPopupMenuImpl menu) {
        this.myPopups.add(menu);
    }

    public void removeActionPopup(ActionPopupMenuImpl menu) {
        boolean removed = this.myPopups.remove((Object)menu);
        if (removed && this.myPopups.isEmpty()) {
            this.flushActionPerformed();
        }
    }

    public void queueActionPerformedEvent(AnAction action, DataContext context, AnActionEvent event) {
        if (!this.myPopups.isEmpty()) {
            this.myQueuedNotifications.put(action, context);
        } else {
            this.fireAfterActionPerformed(action, context, event);
        }
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public boolean isTransparentOnlyActionsUpdateNow() {
        return this.myTransparentOnlyUpdate;
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "replaceAction"));
        }
        if (newAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAction", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "replaceAction"));
        }
        AnAction oldAction = this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup = oldAction instanceof ActionGroup;
            if (isGroup != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            this.unregisterAction(actionId);
            if (isGroup) {
                this.myId2GroupId.values().remove(actionId);
            }
        }
        this.registerAction(actionId, newAction, pluginId);
        for (String groupId : this.myId2GroupId.get((Object)actionId)) {
            DefaultActionGroup group = (DefaultActionGroup)ObjectUtils.assertNotNull((Object)((DefaultActionGroup)this.getActionOrStub(groupId)));
            group.replaceAction(oldAction, newAction);
        }
        return oldAction;
    }

    private void flushActionPerformed() {
        Set<AnAction> actions = this.myQueuedNotifications.keySet();
        for (AnAction eachAction : actions) {
            DataContext eachContext = this.myQueuedNotifications.get(eachAction);
            this.fireAfterActionPerformed(eachAction, eachContext, this.myQueuedNotificationsEvents.get(eachAction));
        }
        this.myQueuedNotifications.clear();
        this.myQueuedNotificationsEvents.clear();
    }

    public void addAnActionListener(AnActionListener listener) {
        this.myActionListeners.add(listener);
    }

    public void addAnActionListener(final AnActionListener listener, Disposable parentDisposable) {
        this.addAnActionListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ActionManagerImpl.this.removeAnActionListener(listener);
            }
        });
    }

    public void removeAnActionListener(AnActionListener listener) {
        this.myActionListeners.remove(listener);
    }

    public void fireBeforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        if (action != null) {
            if (!ourActionsExcludedFromTracking.containsKey(action.getClass())) {
                SystemHealthMonitor.ourStudioActionCount.incrementAndGet();
            }
            this.myPrevPerformedActionId = this.myLastPreformedActionId;
            IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action);
        }
        for (AnActionListener listener : this.myActionListeners) {
            listener.beforeActionPerformed(action, dataContext, event);
        }
    }

    public void fireAfterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        if (action != null) {
            this.myPrevPerformedActionId = this.myLastPreformedActionId;
            IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action);
        }
        for (AnActionListener listener : this.myActionListeners) {
            try {
                listener.afterActionPerformed(action, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "getKeyboardShortcut"));
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c, DataContext dataContext) {
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener : this.myActionListeners) {
            listener.beforeEditorTyping(c, dataContext);
        }
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActionIds() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myId2Action.keySet());
        }
    }

    public Future<?> preloadActions() {
        if (this.myPreloadActionsRunnable == null) {
            this.myPreloadActionsRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        SearchableOptionsRegistrar.getInstance();
                        ActionManagerImpl.this.doPreloadActions();
                    }
                    catch (RuntimeInterruptedException runtimeInterruptedException) {
                        // empty catch block
                    }
                }
            };
            return ApplicationManager.getApplication().executeOnPooledThread(this.myPreloadActionsRunnable);
        }
        return null;
    }

    private void doPreloadActions() {
        ActionManagerImpl.pausePreloading(5000);
        this.preloadActionGroup("EditorPopupMenu");
        this.preloadActionGroup("EditorTabPopupMenu");
        this.preloadActionGroup("ProjectViewPopupMenu");
        this.preloadActionGroup("MainMenu");
        this.preloadActionGroup("NewGroup");
        LOG.debug("Actions preloading completed");
    }

    public void preloadActionGroup(String groupId) {
        AnAction action = this.getAction(groupId);
        if (action instanceof ActionGroup) {
            this.preloadActionGroup((ActionGroup)action);
        }
    }

    private void preloadActionGroup(final ActionGroup group) {
        AnAction[] children2;
        final Application application = ApplicationManager.getApplication();
        for (AnAction action : children2 = (AnAction[])application.runReadAction((Computable)new Computable<AnAction[]>(){

            public AnAction[] compute() {
                if (application.isDisposed()) {
                    return AnAction.EMPTY_ARRAY;
                }
                return group.getChildren(null);
            }
        })) {
            if (action instanceof PreloadableAction) {
                ((PreloadableAction)action).preload();
            } else if (action instanceof ActionGroup) {
                this.preloadActionGroup((ActionGroup)action);
            }
            ++this.myActionsPreloaded;
            if (this.myActionsPreloaded % 10 != 0) continue;
            ActionManagerImpl.pausePreloading(300);
        }
    }

    private static void pausePreloading(int millis) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ignored) {
            throw new RuntimeInterruptedException(ignored);
        }
    }

    public ActionCallback tryToExecute(final @NotNull AnAction action, final @NotNull InputEvent inputEvent, final @Nullable Component contextComponent, final @Nullable String place, boolean now) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ACTION_ELEMENT_NAME, "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "tryToExecute"));
        }
        if (inputEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputEvent", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl", "tryToExecute"));
        }
        Application app = ApplicationManager.getApplication();
        assert (app.isDispatchThread());
        final ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = new Runnable(){

            @Override
            public void run() {
                ActionManagerImpl.this.tryToExecuteNow(action, inputEvent, contextComponent, place, result2);
            }
        };
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        return result2;
    }

    private void tryToExecuteNow(final AnAction action, final InputEvent inputEvent, final Component contextComponent, final String place, final ActionCallback result2) {
        final Presentation presentation = action.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                DataContext context = ActionManagerImpl.getContextBy(contextComponent);
                AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation, (ActionManager)ActionManagerImpl.this, inputEvent.getModifiersEx());
                ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)event, (boolean)false);
                if (!event.getPresentation().isEnabled()) {
                    result2.setRejected();
                    return;
                }
                ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false);
                if (!event.getPresentation().isEnabled()) {
                    result2.setRejected();
                    return;
                }
                Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
                if (component != null && !component.isShowing()) {
                    result2.setRejected();
                    return;
                }
                ActionManagerImpl.this.fireBeforeActionPerformed(action, context, event);
                UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent event) {
                        if (!(event.getID() != 200 && event.getID() != 205 || result2.isProcessed())) {
                            WindowEvent we = (WindowEvent)event;
                            IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable());
                        }
                    }
                }, (long)64L, (Disposable)result2);
                ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                result2.setDone();
                ActionManagerImpl.this.queueActionPerformedEvent(action, context, event);
            }
        });
    }

    static {
        ourActionsExcludedFromTracking.put(BackspaceAction.class, Boolean.TRUE);
    }

    private class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private final List<TimerListener> myTransparentTimerListeners;
        private int myLastTimePerformed;

        MyTimer() {
            super(500, null);
            this.myTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myTransparentTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener.Adapter(){

                public void applicationActivated(IdeFrame ideFrame) {
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(IdeFrame ideFrame) {
                    MyTimer.this.setDelay(5000);
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        public void addTimerListener(TimerListener listener, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).add(listener);
        }

        public void removeTimerListener(TimerListener listener, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            if (IdeFocusManager.getInstance(null).isFocusBeingTransferred()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            boolean transparentOnly = this.myLastTimePerformed == lastEventCount;
            try {
                HashSet<TimerListener> notified = new HashSet<TimerListener>();
                ActionManagerImpl.this.myTransparentOnlyUpdate = transparentOnly;
                this.notifyListeners(this.myTransparentTimerListeners, notified);
                if (transparentOnly) {
                    return;
                }
                this.notifyListeners(this.myTimerListeners, notified);
            }
            finally {
                ActionManagerImpl.this.myTransparentOnlyUpdate = false;
            }
        }

        private void notifyListeners(List<TimerListener> timerListeners, Set<TimerListener> notified) {
            for (TimerListener listener : timerListeners) {
                if (!notified.add(listener)) continue;
                this.runListenerAction(listener);
            }
        }

        private void runListenerAction(TimerListener listener) {
            ModalityState modalityState = listener.getModalityState();
            if (modalityState == null) {
                return;
            }
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }
}

