/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.EventLogCategory;
import com.intellij.notification.EventLogConsole;
import com.intellij.notification.EventLogToolWindowFactory;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLog {
    public static final String LOG_REQUESTOR = "Internal log requestor";
    public static final String LOG_TOOL_WINDOW_ID = "Event Log";
    public static final String HELP_ID = "reference.toolwindows.event.log";
    private static final String A_CLOSING = "</a>";
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final Set<String> NEW_LINES = ContainerUtil.newHashSet((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>"});
    private static final String DEFAULT_CATEGORY = "";
    private final LogModel myModel = new LogModel(null, (Disposable)ApplicationManager.getApplication());

    public EventLog() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new NotificationsAdapter(){

            public void notify(@NotNull Notification notification) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$1", "notify"));
                }
                Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                if (openProjects.length == 0) {
                    EventLog.this.myModel.addNotification(notification);
                }
                for (Project p : openProjects) {
                    EventLog.getProjectComponent(p).printNotification(notification);
                }
            }
        });
    }

    public static void expireNotification(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog", "expireNotification"));
        }
        EventLog.getApplicationComponent().myModel.removeNotification(notification);
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            EventLog.getProjectComponent(p).myProjectModel.removeNotification(notification);
        }
    }

    private static EventLog getApplicationComponent() {
        return (EventLog)ApplicationManager.getApplication().getComponent(EventLog.class);
    }

    @NotNull
    public static LogModel getLogModel(@Nullable Project project) {
        LogModel logModel = project != null ? EventLog.getProjectComponent(project).myProjectModel : EventLog.getApplicationComponent().myModel;
        if (logModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "getLogModel"));
        }
        return logModel;
    }

    @Nullable
    public static Trinity<Notification, String, Long> getStatusMessage(@Nullable Project project) {
        return EventLog.getLogModel(project).getStatusMessage();
    }

    public static LogEntry formatForLog(@NotNull Notification notification, String indent) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog", "formatForLog"));
        }
        DocumentImpl logDoc = new DocumentImpl(DEFAULT_CATEGORY, true);
        AtomicBoolean showMore = new AtomicBoolean(false);
        LinkedHashMap links = new LinkedHashMap();
        ArrayList<RangeMarker> lineSeparators = new ArrayList<RangeMarker>();
        String title = EventLog.truncateLongString(showMore, notification.getTitle());
        String content = EventLog.truncateLongString(showMore, notification.getContent());
        RangeMarker afterTitle = null;
        boolean hasHtml = EventLog.parseHtmlContent(title, notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)content)) {
            EventLog.appendText(logDoc, ": ");
            afterTitle = logDoc.createRangeMarker(logDoc.getTextLength() - 2, logDoc.getTextLength());
        }
        String status = EventLog.getStatusText(logDoc, showMore, lineSeparators, hasHtml |= EventLog.parseHtmlContent(content, notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators));
        EventLog.indentNewLines(logDoc, lineSeparators, afterTitle, hasHtml, indent);
        ArrayList<Pair<TextRange, HyperlinkInfo>> list = new ArrayList<Pair<TextRange, HyperlinkInfo>>();
        for (RangeMarker marker : links.keySet()) {
            if (!marker.isValid()) {
                showMore.set(true);
                continue;
            }
            list.add((Pair<TextRange, HyperlinkInfo>)Pair.create((Object)new TextRange(marker.getStartOffset(), marker.getEndOffset()), links.get(marker)));
        }
        if (showMore.get()) {
            String sb = "show balloon";
            if (!logDoc.getText().endsWith(" ")) {
                EventLog.appendText(logDoc, " ");
            }
            EventLog.appendText(logDoc, "(" + sb + ")");
            list.add((Pair<TextRange, HyperlinkInfo>)new Pair((Object)TextRange.from((int)(logDoc.getTextLength() - 1 - sb.length()), (int)sb.length()), (Object)new ShowBalloon(notification)));
        }
        return new LogEntry(logDoc.getText(), status, list);
    }

    @NotNull
    private static String truncateLongString(AtomicBoolean showMore, String title) {
        if (title.length() > 1000) {
            showMore.set(true);
            String string = title.substring(0, 1000) + "...";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "truncateLongString"));
            }
            return string;
        }
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "truncateLongString"));
        }
        return string;
    }

    private static void indentNewLines(DocumentImpl logDoc, List<RangeMarker> lineSeparators, RangeMarker afterTitle, boolean hasHtml, String indent) {
        if (!hasHtml) {
            int i = -1;
            while ((i = StringUtil.indexOf((CharSequence)logDoc.getText(), (char)'\n', (int)(i + 1))) >= 0) {
                lineSeparators.add(logDoc.createRangeMarker(i, i + 1));
            }
        }
        if (!lineSeparators.isEmpty() && afterTitle != null && afterTitle.isValid()) {
            lineSeparators.add(afterTitle);
        }
        int nextLineStart = -1;
        for (RangeMarker separator : lineSeparators) {
            int start;
            if (!separator.isValid() || (start = separator.getStartOffset()) == nextLineStart) continue;
            logDoc.replaceString(start, separator.getEndOffset(), "\n" + indent);
            nextLineStart = start + 1 + indent.length();
            while (nextLineStart < logDoc.getTextLength() && Character.isWhitespace(logDoc.getCharsSequence().charAt(nextLineStart))) {
                logDoc.deleteString(nextLineStart, nextLineStart + 1);
            }
        }
    }

    private static String getStatusText(DocumentImpl logDoc, AtomicBoolean showMore, List<RangeMarker> lineSeparators, boolean hasHtml) {
        DocumentImpl statusDoc = new DocumentImpl(logDoc.getImmutableCharSequence(), true);
        ArrayList<RangeMarker> statusSeparators = new ArrayList<RangeMarker>();
        for (RangeMarker separator : lineSeparators) {
            if (!separator.isValid()) continue;
            statusSeparators.add(statusDoc.createRangeMarker(separator.getStartOffset(), separator.getEndOffset()));
        }
        EventLog.removeJavaNewLines(statusDoc, statusSeparators, hasHtml);
        EventLog.insertNewLineSubstitutors(statusDoc, showMore, statusSeparators);
        return statusDoc.getText();
    }

    private static boolean parseHtmlContent(String text, Notification notification, Document document, AtomicBoolean showMore, Map<RangeMarker, HyperlinkInfo> links, List<RangeMarker> lineSeparators) {
        String content = StringUtil.convertLineSeparators((String)text);
        int initialLen = document.getTextLength();
        boolean hasHtml = false;
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content)).find()) break;
            String tagStart = tagMatcher.group();
            EventLog.appendText(document, content.substring(0, tagMatcher.start()));
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                String href = aMatcher.group(2);
                int linkEnd = content.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), DEFAULT_CATEGORY);
                    int linkStart = document.getTextLength();
                    EventLog.appendText(document, linkText);
                    links.put(document.createRangeMarker(new TextRange(linkStart, document.getTextLength())), new NotificationHyperlinkInfo(notification, href));
                    content = content.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            hasHtml = true;
            if (NEW_LINES.contains(tagStart)) {
                if (initialLen != document.getTextLength()) {
                    lineSeparators.add(document.createRangeMarker(TextRange.from((int)document.getTextLength(), (int)0)));
                }
            } else if (!("<html>".equals(tagStart) || "</html>".equals(tagStart) || "<body>".equals(tagStart) || "</body>".equals(tagStart))) {
                showMore.set(true);
            }
            content = content.substring(tagMatcher.end());
        }
        EventLog.appendText(document, content);
        Iterator<RangeMarker> iterator = lineSeparators.iterator();
        while (iterator.hasNext()) {
            RangeMarker next = iterator.next();
            if (next.getEndOffset() != document.getTextLength()) continue;
            iterator.remove();
        }
        return hasHtml;
    }

    private static void insertNewLineSubstitutors(Document document, AtomicBoolean showMore, List<RangeMarker> lineSeparators) {
        for (RangeMarker marker : lineSeparators) {
            boolean spaceBefore;
            if (!marker.isValid()) {
                showMore.set(true);
                continue;
            }
            int offset = marker.getStartOffset();
            if (offset == 0 || offset == document.getTextLength()) continue;
            boolean bl = spaceBefore = offset > 0 && Character.isWhitespace(document.getCharsSequence().charAt(offset - 1));
            if (offset < document.getTextLength()) {
                boolean spaceAfter = Character.isWhitespace(document.getCharsSequence().charAt(offset));
                int next = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
                if (next < document.getTextLength() && !Character.isLowerCase(document.getCharsSequence().charAt(next))) {
                    document.insertString(offset, (CharSequence)((spaceBefore ? DEFAULT_CATEGORY : " ") + "//" + (spaceAfter ? DEFAULT_CATEGORY : " ")));
                    continue;
                }
                if (spaceAfter) continue;
            }
            if (spaceBefore) continue;
            document.insertString(offset, (CharSequence)" ");
        }
    }

    private static void removeJavaNewLines(Document document, List<RangeMarker> lineSeparators, boolean hasHtml) {
        CharSequence text = document.getCharsSequence();
        int i = 0;
        while ((i = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)i)) >= 0) {
            document.deleteString(i, i + 1);
            if (hasHtml) continue;
            lineSeparators.add(document.createRangeMarker(TextRange.from((int)i, (int)0)));
        }
    }

    private static void appendText(Document document, String text) {
        text = StringUtil.replace((String)text, (String)"&nbsp;", (String)" ");
        text = StringUtil.replace((String)text, (String)"&raquo;", (String)">>");
        text = StringUtil.replace((String)text, (String)"&laquo;", (String)"<<");
        text = StringUtil.replace((String)text, (String)"&hellip;", (String)"...");
        document.insertString(document.getTextLength(), (CharSequence)StringUtil.unescapeXml((String)text));
    }

    @Nullable
    public static ToolWindow getEventLog(Project project) {
        return project == null ? null : ToolWindowManager.getInstance((Project)project).getToolWindow(LOG_TOOL_WINDOW_ID);
    }

    public static void toggleLog(@Nullable Project project, final @Nullable Notification notification) {
        final ToolWindow eventLog = EventLog.getEventLog(project);
        if (eventLog != null) {
            if (!eventLog.isVisible()) {
                eventLog.activate(new Runnable(){

                    @Override
                    public void run() {
                        if (notification == null) {
                            return;
                        }
                        String contentName = EventLog.getContentName(notification);
                        Content content = eventLog.getContentManager().findContent(contentName);
                        if (content != null) {
                            eventLog.getContentManager().setSelectedContent(content);
                        }
                    }
                }, true);
            } else {
                eventLog.hide(null);
            }
        }
    }

    @NotNull
    private static String getContentName(Notification notification) {
        for (EventLogCategory category : (EventLogCategory[])EventLogCategory.EP_NAME.getExtensions()) {
            if (!category.acceptsNotification(notification.getGroupId())) continue;
            String string = category.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "getContentName"));
            }
            return string;
        }
        if (DEFAULT_CATEGORY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog", "getContentName"));
        }
        return DEFAULT_CATEGORY;
    }

    static ProjectTracker getProjectComponent(Project project) {
        return (ProjectTracker)((Object)project.getComponent(ProjectTracker.class));
    }

    static class ShowBalloon
    implements HyperlinkInfo {
        private final Notification myNotification;
        private RangeHighlighter myRangeHighlighter;

        public ShowBalloon(Notification notification) {
            this.myNotification = notification;
        }

        public void setRangeHighlighter(RangeHighlighter rangeHighlighter) {
            this.myRangeHighlighter = rangeHighlighter;
        }

        public void navigate(Project project) {
            ShowBalloon.hideBalloon(this.myNotification);
            for (Notification notification : EventLog.getLogModel(project).getNotifications()) {
                ShowBalloon.hideBalloon(notification);
            }
            EventLogConsole console = (EventLogConsole)ObjectUtils.assertNotNull((Object)EventLog.getProjectComponent(project).getConsole(this.myNotification));
            if (this.myRangeHighlighter == null || !this.myRangeHighlighter.isValid()) {
                return;
            }
            RelativePoint target = console.getRangeHighlighterLocation(this.myRangeHighlighter);
            if (target != null) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
                assert (frame != null);
                Balloon balloon = NotificationsManagerImpl.createBalloon(frame, this.myNotification, true, true);
                Disposer.register((Disposable)project, (Disposable)balloon);
                balloon.show(target, Balloon.Position.above);
            }
        }

        private static void hideBalloon(Notification notification1) {
            Balloon balloon = notification1.getBalloon();
            if (balloon != null) {
                balloon.hide(true);
            }
        }
    }

    private static class NotificationHyperlinkInfo
    implements HyperlinkInfo {
        private final Notification myNotification;
        private final String myHref;

        public NotificationHyperlinkInfo(Notification notification, String href) {
            this.myNotification = notification;
            this.myHref = href;
        }

        public void navigate(Project project) {
            NotificationListener listener = this.myNotification.getListener();
            if (listener != null) {
                EventLogConsole console = (EventLogConsole)ObjectUtils.assertNotNull((Object)EventLog.getProjectComponent(project).getConsole(this.myNotification));
                JComponent component = console.getConsoleEditor().getContentComponent();
                listener.hyperlinkUpdate(this.myNotification, IJSwingUtilities.createHyperlinkEvent(this.myHref, component));
            }
        }
    }

    public static class ProjectTracker
    extends AbstractProjectComponent {
        private final Map<String, EventLogConsole> myCategoryMap;
        private final List<Notification> myInitial;
        private final LogModel myProjectModel;

        public ProjectTracker(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/EventLog$ProjectTracker", "<init>"));
            }
            super(project);
            this.myCategoryMap = ContainerUtil.newConcurrentMap();
            this.myInitial = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myProjectModel = new LogModel(project, (Disposable)project);
            for (Notification notification : EventLog.getApplicationComponent().myModel.takeNotifications()) {
                this.printNotification(notification);
            }
            project.getMessageBus().connect((Disposable)project).subscribe(Notifications.TOPIC, (Object)new NotificationsAdapter(){

                public void notify(@NotNull Notification notification) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker$1", "notify"));
                    }
                    ProjectTracker.this.printNotification(notification);
                }
            });
        }

        void initDefaultContent() {
            this.createNewContent(EventLog.DEFAULT_CATEGORY);
            for (Notification notification : this.myInitial) {
                this.doPrintNotification(notification, (EventLogConsole)ObjectUtils.assertNotNull((Object)this.getConsole(notification)));
            }
            this.myInitial.clear();
        }

        public void projectOpened() {
        }

        public void projectClosed() {
            EventLog.getApplicationComponent().myModel.setStatusMessage(null, 0L);
            StatusBar.Info.set((String)EventLog.DEFAULT_CATEGORY, null, (String)EventLog.LOG_REQUESTOR);
        }

        private void printNotification(Notification notification) {
            if (!NotificationsConfigurationImpl.getSettings(notification.getGroupId()).isShouldLog()) {
                return;
            }
            this.myProjectModel.addNotification(notification);
            EventLogConsole console = this.getConsole(notification);
            if (console == null) {
                this.myInitial.add(notification);
            } else {
                this.doPrintNotification(notification, console);
            }
        }

        private void doPrintNotification(final @NotNull Notification notification, final @NotNull EventLogConsole console) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker", "doPrintNotification"));
            }
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/notification/EventLog$ProjectTracker", "doPrintNotification"));
            }
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                public void run() {
                    if (!ShutDownTracker.isShutdownHookRunning() && !ProjectTracker.this.myProject.isDisposed()) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                console.doPrintNotification(notification);
                            }
                        });
                    }
                }
            });
        }

        @Nullable
        private EventLogConsole getConsole(Notification notification) {
            if (this.myCategoryMap.get(EventLog.DEFAULT_CATEGORY) == null) {
                return null;
            }
            String name = EventLog.getContentName(notification);
            EventLogConsole console = this.myCategoryMap.get(name);
            return console != null ? console : this.createNewContent(name);
        }

        @NotNull
        private EventLogConsole createNewContent(String name) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            EventLogConsole newConsole = new EventLogConsole(this.myProjectModel);
            EventLogToolWindowFactory.createContent(this.myProject, EventLog.getEventLog(this.myProject), newConsole, name);
            this.myCategoryMap.put(name, newConsole);
            EventLogConsole eventLogConsole = newConsole;
            if (eventLogConsole == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLog$ProjectTracker", "createNewContent"));
            }
            return eventLogConsole;
        }
    }

    public static class LogEntry {
        public final String message;
        public final String status;
        public final List<Pair<TextRange, HyperlinkInfo>> links;

        public LogEntry(@NotNull String message, @NotNull String status, @NotNull List<Pair<TextRange, HyperlinkInfo>> links) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/notification/EventLog$LogEntry", "<init>"));
            }
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/notification/EventLog$LogEntry", "<init>"));
            }
            if (links == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "links", "com/intellij/notification/EventLog$LogEntry", "<init>"));
            }
            this.message = message;
            this.status = status;
            this.links = links;
        }
    }
}

