/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.google.common.collect.ImmutableMap;
import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonColorsPage
implements ColorSettingsPage,
InspectionColorSettingsPage,
DisplayPrioritySortable {
    private static final Map<String, TextAttributesKey> ourAdditionalHighlighting = ImmutableMap.of((Object)"propertyKey", (Object)JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY);
    private static final AttributesDescriptor[] ourAttributeDescriptors = new AttributesDescriptor[]{new AttributesDescriptor("Property key", JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY), new AttributesDescriptor("Braces", JsonSyntaxHighlighterFactory.JSON_BRACES), new AttributesDescriptor("Brackets", JsonSyntaxHighlighterFactory.JSON_BRACKETS), new AttributesDescriptor("Comma", JsonSyntaxHighlighterFactory.JSON_COMMA), new AttributesDescriptor("Colon", JsonSyntaxHighlighterFactory.JSON_COLON), new AttributesDescriptor("Number", JsonSyntaxHighlighterFactory.JSON_NUMBER), new AttributesDescriptor("String", JsonSyntaxHighlighterFactory.JSON_STRING), new AttributesDescriptor("Keyword", JsonSyntaxHighlighterFactory.JSON_KEYWORD), new AttributesDescriptor("Line comment", JsonSyntaxHighlighterFactory.JSON_LINE_COMMENT), new AttributesDescriptor("Block comment", JsonSyntaxHighlighterFactory.JSON_BLOCK_COMMENT), new AttributesDescriptor("Valid escape sequence", JsonSyntaxHighlighterFactory.JSON_VALID_ESCAPE), new AttributesDescriptor("Invalid escape sequence", JsonSyntaxHighlighterFactory.JSON_INVALID_ESCAPE)};

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)JsonLanguage.INSTANCE, null, null);
        if (syntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonColorsPage", "getHighlighter"));
        }
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("{\n  // Line comments are not included in standard but nonetheless allowed.\n  /* As well as block comments. */\n  <propertyKey>\"the only keywords are\"</propertyKey>: [true, false, null],\n  <propertyKey>\"strings with\"</propertyKey>: {\n    <propertyKey>\"no excapes\"</propertyKey>: \"pseudopolinomiality\"\n    <propertyKey>\"valid escapes\"</propertyKey>: \"C-style\\r\\n and unicode\\u0021\",\n    <propertyKey>\"illegal escapes\"</propertyKey>: \"\\0377\\x\\\"\n  },\n  <propertyKey>\"some numbers\"</propertyKey>: [\n    42,\n    -0.0e-0,\n    6.626e-34\n  ] \n}" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonColorsPage", "getDemoText"));
        }
        return "{\n  // Line comments are not included in standard but nonetheless allowed.\n  /* As well as block comments. */\n  <propertyKey>\"the only keywords are\"</propertyKey>: [true, false, null],\n  <propertyKey>\"strings with\"</propertyKey>: {\n    <propertyKey>\"no excapes\"</propertyKey>: \"pseudopolinomiality\"\n    <propertyKey>\"valid escapes\"</propertyKey>: \"C-style\\r\\n and unicode\\u0021\",\n    <propertyKey>\"illegal escapes\"</propertyKey>: \"\\0377\\x\\\"\n  },\n  <propertyKey>\"some numbers\"</propertyKey>: [\n    42,\n    -0.0e-0,\n    6.626e-34\n  ] \n}";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ourAdditionalHighlighting;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ourAttributeDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonColorsPage", "getAttributeDescriptors"));
        }
        return ourAttributeDescriptors;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonColorsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        if ("JSON" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonColorsPage", "getDisplayName"));
        }
        return "JSON";
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.LANGUAGE_SETTINGS;
    }
}

