/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionContextBase;
import com.intellij.ide.util.importProject.FacetBasedDetectedFrameworkDescriptionInWizard;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkDetectionInWizardContext
extends FrameworkDetectionContextBase {
    protected FrameworkDetectionInWizardContext() {
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> List<? extends DetectedFrameworkDescription> createDetectedFacetDescriptions(@NotNull FacetBasedFrameworkDetector<F, C> detector, @NotNull Collection<VirtualFile> files) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/ide/util/importProject/FrameworkDetectionInWizardContext", "createDetectedFacetDescriptions"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/util/importProject/FrameworkDetectionInWizardContext", "createDetectedFacetDescriptions"));
        }
        List<ModuleDescriptor> descriptors = this.getModuleDescriptors();
        MultiMap filesByModule = new MultiMap();
        for (VirtualFile file2 : files) {
            File ioFile = VfsUtil.virtualToIoFile((VirtualFile)file2);
            ModuleDescriptor descriptor = FrameworkDetectionInWizardContext.findDescriptorByFile(descriptors, ioFile);
            if (descriptor == null) continue;
            filesByModule.putValue((Object)descriptor, (Object)file2);
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>> result2 = new ArrayList<FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>>();
        FacetType facetType = detector.getFacetType();
        for (ModuleDescriptor module : filesByModule.keySet()) {
            if (!facetType.isSuitableModuleType(module.getModuleType())) continue;
            List pairs = detector.createConfigurations(filesByModule.get((Object)module), Collections.emptyList());
            for (Pair pair : pairs) {
                result2.add(new FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>(module, detector, (FacetConfiguration)pair.getFirst(), new HashSet<VirtualFile>((Collection)pair.getSecond())));
            }
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/FrameworkDetectionInWizardContext", "createDetectedFacetDescriptions"));
        }
        return arrayList;
    }

    protected abstract List<ModuleDescriptor> getModuleDescriptors();

    @Nullable
    private static ModuleDescriptor findDescriptorByFile(List<ModuleDescriptor> descriptors, File file2) {
        ModuleDescriptor result2 = null;
        File nearestRoot = null;
        for (ModuleDescriptor descriptor : descriptors) {
            for (File root : descriptor.getContentRoots()) {
                if (!FileUtil.isAncestor((File)root, (File)file2, (boolean)false) || nearestRoot != null && !FileUtil.isAncestor(nearestRoot, (File)root, (boolean)true)) continue;
                result2 = descriptor;
                nearestRoot = root;
            }
        }
        return result2;
    }

    public VirtualFile getBaseDir() {
        String path = this.getContentPath();
        return path != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : null;
    }

    @Nullable
    protected abstract String getContentPath();
}

