/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TipPanel;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipDialog
extends DialogWrapper {
    private TipPanel myTipPanel;

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public TipDialog() {
        super((Component)WindowManagerEx.getInstanceEx().findVisibleFrame(), true);
        this.initialize();
    }

    public TipDialog(@NotNull Window parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/util/TipDialog", "<init>"));
        }
        super((Component)parent, true);
        this.initialize();
    }

    private void initialize() {
        this.setModal(false);
        this.setTitle(IdeBundle.message((String)"title.tip.of.the.day", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myTipPanel = new TipPanel();
        this.myTipPanel.nextTip();
        this.setHorizontalStretch(1.33f);
        this.setVerticalStretch(1.25f);
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new PreviousTipAction(), new NextTipAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TipDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myTipPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public static TipDialog createForProject(Project project) {
        Window w = WindowManagerEx.getInstanceEx().suggestParentWindow(project);
        return w == null ? new TipDialog() : new TipDialog(w);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    private class NextTipAction
    extends AbstractAction {
        public NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
            this.putValue("FocusedAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipDialog.this.myTipPanel.nextTip();
            UsageTrigger.trigger("tips.of.the.day.next");
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        public PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipDialog.this.myTipPanel.prevTip();
            UsageTrigger.trigger("tips.of.the.day.prev");
        }
    }
}

