/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.impl.StructureViewState;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageStructureViewBuilder
implements StructureViewBuilder {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    @Nullable
    private Language myTemplateDataLanguage;
    private StructureViewComposite.StructureViewDescriptor myBaseStructureViewDescriptor;
    private FileEditor myFileEditor;
    private StructureViewComposite myStructureViewComposite;
    private int myBaseLanguageViewDescriptorIndex;

    protected TemplateLanguageStructureViewBuilder(PsiElement psiElement) {
        this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
        this.myProject = psiElement.getProject();
        this.myTemplateDataLanguage = this.getTemplateDataLanguage();
    }

    private void updateAfterPsiChange() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (this.myBaseStructureViewDescriptor != null && ((StructureViewComponent)this.myBaseStructureViewDescriptor.structureView).getTree() == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!TemplateLanguageStructureViewBuilder.this.myVirtualFile.isValid() || TemplateLanguageStructureViewBuilder.this.getViewProvider() == null) {
                    return;
                }
                StructureViewWrapper structureViewWrapper = StructureViewFactoryEx.getInstanceEx(TemplateLanguageStructureViewBuilder.this.myProject).getStructureViewWrapper();
                if (structureViewWrapper == null) {
                    return;
                }
                Language baseLanguage = TemplateLanguageStructureViewBuilder.this.getTemplateDataLanguage();
                if (baseLanguage == TemplateLanguageStructureViewBuilder.this.myTemplateDataLanguage && (TemplateLanguageStructureViewBuilder.this.myBaseStructureViewDescriptor == null || TemplateLanguageStructureViewBuilder.isPsiValid(TemplateLanguageStructureViewBuilder.this.myBaseStructureViewDescriptor))) {
                    TemplateLanguageStructureViewBuilder.this.updateBaseLanguageView();
                } else {
                    TemplateLanguageStructureViewBuilder.this.myTemplateDataLanguage = baseLanguage;
                    ((StructureViewWrapperImpl)structureViewWrapper).rebuild();
                }
            }
        });
    }

    private static boolean isPsiValid(@NotNull StructureViewComposite.StructureViewDescriptor baseStructureViewDescriptor) {
        Object psi;
        TreeElement value;
        if (baseStructureViewDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseStructureViewDescriptor", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder", "isPsiValid"));
        }
        StructureViewComponent view = (StructureViewComponent)baseStructureViewDescriptor.structureView;
        if (view.isDisposed()) {
            return false;
        }
        Object root = view.getTreeStructure().getRootElement();
        if (root instanceof StructureViewComponent.StructureViewTreeElementWrapper && (value = (TreeElement)((StructureViewComponent.StructureViewTreeElementWrapper)((Object)root)).getValue()) instanceof StructureViewTreeElement && (psi = ((StructureViewTreeElement)value).getValue()) instanceof PsiElement) {
            return ((PsiElement)psi).isValid();
        }
        return true;
    }

    @Nullable
    private FileViewProvider getViewProvider() {
        return PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myVirtualFile);
    }

    @Nullable
    private Language getTemplateDataLanguage() {
        FileViewProvider provider = this.getViewProvider();
        return provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : null;
    }

    private void updateBaseLanguageView() {
        PsiElement element;
        if (this.myBaseStructureViewDescriptor == null || !this.myProject.isOpen()) {
            return;
        }
        StructureViewComponent view = (StructureViewComponent)this.myBaseStructureViewDescriptor.structureView;
        if (view.isDisposed()) {
            return;
        }
        StructureViewState state = view.getState();
        List<PsiAnchor> expanded = TemplateLanguageStructureViewBuilder.collectAnchors(state.getExpandedElements());
        List<PsiAnchor> selected = TemplateLanguageStructureViewBuilder.collectAnchors(state.getSelectedElements());
        this.updateTemplateDataFileView();
        if (view.isDisposed()) {
            return;
        }
        for (PsiAnchor pointer : expanded) {
            element = pointer.retrieve();
            if (element == null) continue;
            view.expandPathToElement(element);
        }
        for (PsiAnchor pointer : selected) {
            element = pointer.retrieve();
            if (element == null) continue;
            view.addSelectionPathTo(element);
        }
    }

    private static List<PsiAnchor> collectAnchors(Object[] expandedElements) {
        ArrayList<PsiAnchor> expanded = new ArrayList<PsiAnchor>(expandedElements == null ? 0 : expandedElements.length);
        if (expandedElements != null) {
            for (Object element : expandedElements) {
                if (!(element instanceof PsiElement) || !((PsiElement)element).isValid()) continue;
                expanded.add(PsiAnchor.create((PsiElement)element));
            }
        }
        return expanded;
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder", "createStructureView"));
        }
        this.myFileEditor = fileEditor;
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        FileViewProvider provider = this.getViewProvider();
        assert (provider != null) : this.myVirtualFile;
        StructureViewComposite.StructureViewDescriptor structureViewDescriptor = this.createMainView(fileEditor, provider.getPsi(provider.getBaseLanguage()));
        if (structureViewDescriptor != null) {
            viewDescriptors.add(structureViewDescriptor);
        }
        this.myBaseLanguageViewDescriptorIndex = -1;
        this.updateTemplateDataFileView();
        if (this.myBaseStructureViewDescriptor != null) {
            viewDescriptors.add(this.myBaseStructureViewDescriptor);
            this.myBaseLanguageViewDescriptorIndex = viewDescriptors.size() - 1;
        }
        if (provider instanceof TemplateLanguageFileViewProvider) {
            Language dataLanguage = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
            for (Language language : provider.getLanguages()) {
                if (language == dataLanguage || language == provider.getBaseLanguage()) continue;
                ContainerUtil.addIfNotNull((Object)this.createBaseLanguageStructureView(fileEditor, language), viewDescriptors);
            }
        }
        StructureViewComposite.StructureViewDescriptor[] array = viewDescriptors.toArray(new StructureViewComposite.StructureViewDescriptor[viewDescriptors.size()]);
        this.myStructureViewComposite = new StructureViewComposite(array);
        project.getMessageBus().connect((Disposable)this.myStructureViewComposite).subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
            final Alarm alarm;
            {
                this.alarm = new Alarm((Disposable)TemplateLanguageStructureViewBuilder.this.myStructureViewComposite);
            }

            public void modificationCountChanged() {
                this.alarm.cancelAllRequests();
                this.alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        TemplateLanguageStructureViewBuilder.this.updateAfterPsiChange();
                    }
                }, 300, ModalityState.NON_MODAL);
            }
        });
        StructureViewComposite structureViewComposite = this.myStructureViewComposite;
        if (structureViewComposite == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder", "createStructureView"));
        }
        return structureViewComposite;
    }

    protected abstract StructureViewComposite.StructureViewDescriptor createMainView(FileEditor var1, PsiFile var2);

    @Nullable
    private StructureViewComposite.StructureViewDescriptor createBaseLanguageStructureView(FileEditor fileEditor, Language language) {
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        FileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider == null) {
            return null;
        }
        PsiFile dataFile = viewProvider.getPsi(language);
        if (dataFile == null || !this.isAcceptableBaseLanguageFile(dataFile)) {
            return null;
        }
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
        if (factory == null) {
            return null;
        }
        StructureViewBuilder builder = factory.getStructureViewBuilder(dataFile);
        if (builder == null) {
            return null;
        }
        StructureView structureView = builder.createStructureView(fileEditor, this.myProject);
        return new StructureViewComposite.StructureViewDescriptor(IdeBundle.message((String)"tab.structureview.baselanguage.view", (Object[])new Object[]{language.getDisplayName()}), structureView, TemplateLanguageStructureViewBuilder.findFileType(language).getIcon());
    }

    protected boolean isAcceptableBaseLanguageFile(PsiFile dataFile) {
        return true;
    }

    private void updateTemplateDataFileView() {
        Language newDataLanguage = this.getTemplateDataLanguage();
        if (this.myBaseStructureViewDescriptor != null) {
            if (this.myTemplateDataLanguage == newDataLanguage) {
                return;
            }
            Disposer.dispose((Disposable)this.myBaseStructureViewDescriptor.structureView);
        }
        if (newDataLanguage != null) {
            this.myBaseStructureViewDescriptor = this.createBaseLanguageStructureView(this.myFileEditor, newDataLanguage);
            if (this.myStructureViewComposite != null) {
                this.myStructureViewComposite.setStructureView(this.myBaseLanguageViewDescriptorIndex, this.myBaseStructureViewDescriptor);
            }
        }
    }

    @NotNull
    private static FileType findFileType(Language language) {
        FileType[] registeredFileTypes;
        for (FileType fileType : registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != language) continue;
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder", "findFileType"));
            }
            return fileType2;
        }
        FileType fileType = FileTypes.UNKNOWN;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder", "findFileType"));
        }
        return fileType;
    }
}

