/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.script.IDE;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;

public class IdeScriptBindings {
    public static final Binding<IDE> IDE = Binding.create("IDE", IDE.class);

    public static void ensureIdeIsBound(@Nullable Project project, @NotNull IdeScriptEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ide/script/IdeScriptBindings", "ensureIdeIsBound"));
        }
        IDE oldIdeBinding = IDE.get(engine);
        if (oldIdeBinding == null) {
            IDE.set(engine, new IDE(project, engine));
        }
    }

    private IdeScriptBindings() {
    }

    public static class Binding<T> {
        private final String myName;
        private final Class<T> myClass;

        private Binding(@NotNull String name, @NotNull Class<T> clazz) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/script/IdeScriptBindings$Binding", "<init>"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/ide/script/IdeScriptBindings$Binding", "<init>"));
            }
            this.myName = name;
            this.myClass = clazz;
        }

        public void set(@NotNull IdeScriptEngine engine, T value) {
            if (engine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ide/script/IdeScriptBindings$Binding", "set"));
            }
            engine.setBinding(this.myName, value);
        }

        public T get(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ide/script/IdeScriptBindings$Binding", "get"));
            }
            return (T)ObjectUtils.tryCast((Object)engine.getBinding(this.myName), this.myClass);
        }

        static <T> Binding<T> create(@NotNull String name, @NotNull Class<T> clazz) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/script/IdeScriptBindings$Binding", "create"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/ide/script/IdeScriptBindings$Binding", "create"));
            }
            return new Binding<T>(name, clazz);
        }
    }
}

