/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRootsUtil {
    private ProjectRootsUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory psiDirectory) {
        return ProjectRootsUtil.isSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject());
    }

    public static boolean isSourceRoot(VirtualFile directoryFile, Project project) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return directoryFile.equals(fileIndex.getSourceRootForFile(directoryFile));
    }

    public static boolean isInSource(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isInSource"));
        }
        return ProjectRootsUtil.isInSource(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isInSource(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryFile", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isInSource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isInSource"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInSourceContent(directoryFile);
    }

    public static boolean isInTestSource(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isInTestSource"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        return vFile != null && ProjectRootsUtil.isInTestSource(vFile, file2.getProject());
    }

    public static boolean isInTestSource(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryFile", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isInTestSource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isInTestSource"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInTestSourceContent(directoryFile);
    }

    public static boolean isModuleSourceRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleSourceRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleSourceRoot"));
        }
        return ProjectRootsUtil.getModuleSourceRoot(virtualFile, project) != null;
    }

    @Nullable
    public static SourceFolder getModuleSourceRoot(@NotNull VirtualFile root, @NotNull Project project) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "getModuleSourceRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "getModuleSourceRoot"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(root);
        return module != null && !module.isDisposed() ? ProjectRootsUtil.findSourceFolder(module, root) : null;
    }

    public static boolean isLibraryRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryFile", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isLibraryRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isLibraryRoot"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (projectFileIndex.isInLibraryClasses(directoryFile)) {
            VirtualFile parent = directoryFile.getParent();
            return parent == null || !projectFileIndex.isInLibraryClasses(parent);
        }
        return false;
    }

    public static boolean isModuleContentRoot(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleContentRoot"));
        }
        return ProjectRootsUtil.isModuleContentRoot(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isModuleContentRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryFile", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleContentRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleContentRoot"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRootForFile = projectFileIndex.getContentRootForFile(directoryFile);
        return directoryFile.equals(contentRootForFile);
    }

    public static boolean isProjectHome(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isProjectHome"));
        }
        return psiDirectory.getVirtualFile().equals(psiDirectory.getProject().getBaseDir());
    }

    public static boolean isOutsideSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isInSource(file2) && !projectFileIndex.isInLibraryClasses(file2);
    }

    @Nullable
    public static SourceFolder findSourceFolder(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "findSourceFolder"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "findSourceFolder"));
        }
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!root.equals(folder.getFile())) continue;
                return folder;
            }
        }
        return null;
    }

    @Nullable
    public static ExcludeFolder findExcludeFolder(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "findExcludeFolder"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "findExcludeFolder"));
        }
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (ExcludeFolder folder : entry.getExcludeFolders()) {
                if (!root.equals(folder.getFile())) continue;
                return folder;
            }
        }
        return null;
    }
}

