/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManager
extends PluginManagerCore {
    @NonNls
    public static final String INSTALLED_TXT = "installed.txt";
    public static long startupStart;
    private static Thread.UncaughtExceptionHandler HANDLER;

    protected static void start(final String mainClass, final String methodName, final String[] args) {
        startupStart = System.nanoTime();
        Main.setFlags((String[])args);
        if (!Main.isHeadless()) {
            UIUtil.initDefaultLAF();
        }
        ThreadGroup threadGroup = new ThreadGroup("Idea Thread Group"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                PluginManager.processException(e);
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    ClassUtilCore.clearJarURLCache();
                    Class<?> aClass = Class.forName(mainClass);
                    Method method = aClass.getDeclaredMethod(methodName, ArrayUtil.EMPTY_STRING_ARRAY.getClass());
                    method.setAccessible(true);
                    Object[] argsArray = new Object[]{args};
                    method.invoke(null, argsArray);
                }
                catch (Throwable t) {
                    throw new StartupAbortedException(t);
                }
            }
        };
        new Thread(threadGroup, runnable2, "Idea Main Thread").start();
    }

    public static void processException(Throwable t) {
        if (!IdeaApplication.isLoaded()) {
            PluginException pe;
            PluginId pluginId;
            StartupAbortedException se = PluginManager.findCause(t, StartupAbortedException.class);
            if (se == null) {
                se = new StartupAbortedException(t);
            }
            PluginId pluginId2 = pluginId = (pe = PluginManager.findCause(t, PluginException.class)) != null ? pe.getPluginId() : null;
            if (Logger.isInitialized() && !(t instanceof ProcessCanceledException)) {
                try {
                    PluginManager.getLogger().error(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (pluginId != null && !"com.intellij".equals(pluginId.getIdString())) {
                PluginManager.disablePlugin(pluginId.getIdString());
                StringWriter message = new StringWriter();
                message.append("Plugin '").append(pluginId.getIdString()).append("' failed to initialize and will be disabled. ");
                message.append(" Please restart ").append(ApplicationNamesInfo.getInstance().getFullProductName()).append('.');
                message.append("\n\n");
                pe.getCause().printStackTrace(new PrintWriter(message));
                Main.showMessage((String)"Plugin Error", (String)message.toString(), (boolean)false);
                StudioCrashDetection.stop();
                System.exit(8);
            } else {
                Main.showMessage((String)"Start Failed", (Throwable)t);
                System.exit(se.exitCode());
            }
        } else if (!(t instanceof ProcessCanceledException)) {
            PluginManager.getLogger().error(t);
        }
    }

    private static <T extends Throwable> T findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return (T)((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return null;
    }

    public static void installExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(HANDLER);
    }

    public static void reportPluginError() {
        if (myPluginError != null) {
            String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
            Notifications.Bus.notify((Notification)new Notification(title, title, myPluginError, NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/plugins/PluginManager$4", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManager$4", "hyperlinkUpdate"));
                    }
                    notification.expire();
                    String description = event.getDescription();
                    if ("edit".equals(description)) {
                        PluginManagerConfigurable configurable = new PluginManagerConfigurable(PluginManagerUISettings.getInstance());
                        IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                        ShowSettingsUtil.getInstance().editConfigurable((Component)((JFrame)ideFrame), (Configurable)configurable);
                        return;
                    }
                    List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
                    if (PluginManagerCore.myPlugins2Disable != null && "disable".equals(description)) {
                        for (String pluginId : PluginManagerCore.myPlugins2Disable) {
                            if (disabledPlugins.contains(pluginId)) continue;
                            disabledPlugins.add(pluginId);
                        }
                    } else if (PluginManagerCore.myPlugins2Enable != null && "enable".equals(description)) {
                        disabledPlugins.removeAll(PluginManagerCore.myPlugins2Enable);
                        PluginManagerMain.notifyPluginsUpdated(null);
                    }
                    try {
                        PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    PluginManagerCore.myPlugins2Enable = null;
                    PluginManagerCore.myPlugins2Disable = null;
                }
            }));
            myPluginError = null;
        }
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManager.getPlugin(id) != null;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        IdeaPluginDescriptor[] plugins2;
        for (IdeaPluginDescriptor plugin : plugins2 = PluginManager.getPlugins()) {
            if (!Comparing.equal((Object)id, (Object)plugin.getPluginId())) continue;
            return plugin;
        }
        return null;
    }

    public static void handleComponentError(Throwable t, @Nullable String componentClassName, @Nullable PluginId pluginId) {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        if (t instanceof StartupAbortedException) {
            throw (StartupAbortedException)t;
        }
        if ((pluginId == null || "com.intellij".equals(pluginId.getIdString())) && componentClassName != null) {
            pluginId = PluginManager.getPluginByClassName(componentClassName);
        }
        if ((pluginId == null || "com.intellij".equals(pluginId.getIdString())) && t instanceof PicoPluginExtensionInitializationException) {
            pluginId = ((PicoPluginExtensionInitializationException)t).getPluginId();
        }
        if (pluginId != null && !"com.intellij".equals(pluginId.getIdString())) {
            throw new StartupAbortedException((Throwable)new PluginException(t, pluginId));
        }
        throw new StartupAbortedException("Fatal error initializing '" + componentClassName + "'", t);
    }

    static {
        HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                PluginManager.processException(e);
            }
        };
    }

    private static class StartupAbortedException
    extends RuntimeException {
        private int exitCode = 3;

        public StartupAbortedException(Throwable cause) {
            super(cause);
        }

        public StartupAbortedException(String message, Throwable cause) {
            super(message, cause);
        }

        public int exitCode() {
            return this.exitCode;
        }

        public StartupAbortedException exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }
    }
}

