/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.FileHistoryDialogModel;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExcludingTraversalPolicy;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class FileHistoryDialog
extends HistoryDialog<FileHistoryDialogModel> {
    private DiffRequestPanel myDiffPanel;

    public FileHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/history/integration/ui/views/FileHistoryDialog", "<init>"));
        }
        this(p, gw, f, true);
    }

    protected FileHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f, boolean doInit) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/history/integration/ui/views/FileHistoryDialog", "<init>"));
        }
        super(p, gw, f, doInit);
    }

    @Override
    protected FileHistoryDialogModel createModel(LocalHistoryFacade vcs) {
        return new EntireFileHistoryDialogModel(this.myProject, this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Pair<JComponent, Dimension> createDiffPanel(JPanel root, ExcludingTraversalPolicy traversalPolicy) {
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, this.getFrame());
        return Pair.create((Object)this.myDiffPanel.getComponent(), null);
    }

    @Override
    protected void setDiffBorder(Border border) {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myDiffPanel != null) {
            Disposer.dispose((Disposable)this.myDiffPanel);
        }
    }

    @Override
    protected Runnable doUpdateDiffs(FileHistoryDialogModel model) {
        final FileDifferenceModel diffModel = model.getDifferenceModel();
        return new Runnable(){

            @Override
            public void run() {
                FileHistoryDialog.this.myDiffPanel.setRequest((DiffRequest)FileHistoryDialog.this.createDifference(diffModel));
            }
        };
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.showhistory";
    }
}

