/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.TextMergeTool;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeChange
extends ThreesideDiffChangeBase {
    private static final String CTRL_CLICK_TO_RESOLVE = "Ctrl+click to resolve conflict";
    @NotNull
    private final TextMergeTool.TextMergeViewer myMergeViewer;
    @NotNull
    private final TextMergeTool.TextMergeViewer.MyThreesideViewer myViewer;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<MyGutterOperation> myOperations;
    private final int[] myStartLines;
    private final int[] myEndLines;
    private final boolean[] myResolved;
    private boolean myOnesideAppliedConflict;

    public TextMergeChange(@NotNull MergeLineFragment fragment, @NotNull TextMergeTool.TextMergeViewer viewer) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/merge/TextMergeChange", "<init>"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/merge/TextMergeChange", "<init>"));
        }
        super(fragment, viewer.getViewer().getEditors(), ComparisonPolicy.DEFAULT);
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myStartLines = new int[3];
        this.myEndLines = new int[3];
        this.myResolved = new boolean[2];
        this.myMergeViewer = viewer;
        this.myViewer = viewer.getViewer();
        for (ThreeSide side : ThreeSide.values()) {
            this.myStartLines[side.getIndex()] = fragment.getStartLine(side);
            this.myEndLines[side.getIndex()] = fragment.getEndLine(side);
        }
        this.installHighlighter();
    }

    void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.getType().isLeftChange()) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.getType().isRightChange()) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
        this.doInstallActionHighlighters();
    }

    void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    void doReinstallHighlighter() {
        this.destroyHighlighter();
        this.installHighlighter();
        this.myViewer.repaintDividers();
    }

    private void createHighlighter(@NotNull ThreeSide side) {
        int start;
        int end;
        int endLine;
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createHighlighter"));
        }
        Editor editor = (Editor)side.select(this.myViewer.getEditors());
        Document document = editor.getDocument();
        TextDiffType type = this.getDiffType();
        boolean resolved = this.isResolved(side);
        int startLine = this.getStartLine(side);
        if (startLine == (endLine = this.getEndLine(side))) {
            end = startLine < DiffUtil.getLineCount(document) ? document.getLineStartOffset(startLine) : document.getTextLength();
            start = end;
        } else {
            start = document.getLineStartOffset(startLine);
            end = document.getLineEndOffset(endLine - 1);
            if (end < document.getTextLength()) {
                ++end;
            }
        }
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, start, end, type, false, HighlighterTargetArea.EXACT_RANGE, resolved));
        if (startLine == endLine) {
            if (startLine != 0) {
                this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, true, resolved));
            }
        } else {
            this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, startLine, type, SeparatorPlacement.TOP, false, resolved));
            this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, false, resolved));
        }
    }

    void setResolved(@NotNull Side side, boolean value) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "setResolved"));
        }
        this.myResolved[side.getIndex()] = value;
    }

    public boolean isResolved() {
        return this.myResolved[0] && this.myResolved[1];
    }

    public boolean isResolved(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "isResolved"));
        }
        return side.select(this.myResolved);
    }

    public boolean isOnesideAppliedConflict() {
        return this.myOnesideAppliedConflict;
    }

    public void markOnesideAppliedConflict() {
        this.myOnesideAppliedConflict = true;
    }

    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "isResolved"));
        }
        switch (side) {
            case LEFT: {
                return this.isResolved(Side.LEFT);
            }
            case BASE: {
                return this.isResolved();
            }
            case RIGHT: {
                return this.isResolved(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "getStartLine"));
        }
        return side.select(this.myStartLines);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "getEndLine"));
        }
        return side.select(this.myEndLines);
    }

    public void setStartLine(@NotNull ThreeSide side, int value) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "setStartLine"));
        }
        this.myStartLines[side.getIndex()] = value;
    }

    public void setEndLine(@NotNull ThreeSide side, int value) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "setEndLine"));
        }
        this.myEndLines[side.getIndex()] = value;
    }

    @Nullable
    State processBaseChange(int oldLine1, int oldLine2, int shift) {
        State oldState;
        int line1 = this.getStartLine(ThreeSide.BASE);
        int line2 = this.getEndLine(ThreeSide.BASE);
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        boolean rangeAffected = newRange.damaged || oldLine2 >= line1 && oldLine1 <= line2;
        State state = oldState = rangeAffected ? this.storeState() : null;
        if (newRange.startLine == newRange.endLine && this.getDiffType() == TextDiffType.DELETED && !this.isResolved()) {
            if (oldState == null) {
                oldState = this.storeState();
            }
            this.myViewer.markChangeResolved(this);
        }
        this.setStartLine(ThreeSide.BASE, newRange.startLine);
        this.setEndLine(ThreeSide.BASE, newRange.endLine);
        return oldState;
    }

    private void doInstallActionHighlighters() {
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.LEFT, OperationType.APPLY));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.LEFT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.RIGHT, OperationType.APPLY));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.RIGHT, OperationType.IGNORE));
    }

    @Nullable
    private MyGutterOperation createOperation(@NotNull ThreeSide side, @NotNull OperationType type) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createOperation"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/merge/TextMergeChange", "createOperation"));
        }
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(side);
        DocumentEx document = editor.getDocument();
        int line = this.getStartLine(side);
        int offset = line == DiffUtil.getLineCount(document) ? document.getTextLength() : document.getLineStartOffset(line);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(side, highlighter, type);
    }

    public void updateGutterActions(boolean force) {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(final @NotNull Side side, final boolean modifier) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createApplyRenderer"));
        }
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon = this.isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        return this.createIconRenderer(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), icon, this.isConflict(), new Runnable(){

            @Override
            public void run() {
                TextMergeChange.this.myViewer.executeMergeCommand("Apply change", Collections.singletonList(TextMergeChange.this), new Runnable(){

                    @Override
                    public void run() {
                        TextMergeChange.this.myViewer.replaceChange(TextMergeChange.this, side, modifier);
                    }
                });
            }
        });
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer(final @NotNull Side side, final boolean modifier) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createIgnoreRenderer"));
        }
        if (this.isResolved(side)) {
            return null;
        }
        return this.createIconRenderer(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), AllIcons.Diff.Remove, this.isConflict(), new Runnable(){

            @Override
            public void run() {
                TextMergeChange.this.myViewer.executeMergeCommand(null, Collections.singletonList(TextMergeChange.this), new Runnable(){

                    @Override
                    public void run() {
                        TextMergeChange.this.myViewer.ignoreChange(TextMergeChange.this, side, modifier);
                    }
                });
            }
        });
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(@NotNull String text, @NotNull Icon icon, boolean ctrlClickVisible, final @NotNull Runnable perform) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        if (perform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "perform", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        String tooltipText = DiffUtil.createTooltipText(text, ctrlClickVisible ? CTRL_CLICK_TO_RESOLVE : null);
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                perform.run();
            }
        };
    }

    @NotNull
    State storeState() {
        State state = new State(this.myStartLines[0], this.myStartLines[1], this.myStartLines[2], this.myEndLines[0], this.myEndLines[1], this.myEndLines[2], this.myResolved[0], this.myResolved[1], this.myOnesideAppliedConflict);
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeChange", "storeState"));
        }
        return state;
    }

    void restoreState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/merge/TextMergeChange", "restoreState"));
        }
        this.myStartLines[0] = state.myStartLine1;
        this.myStartLines[1] = state.myStartLine2;
        this.myStartLines[2] = state.myStartLine3;
        this.myEndLines[0] = state.myEndLine1;
        this.myEndLines[1] = state.myEndLine2;
        this.myEndLines[2] = state.myEndLine3;
        this.myResolved[0] = state.myResolved1;
        this.myResolved[1] = state.myResolved2;
        this.myOnesideAppliedConflict = state.myOnesideAppliedConflict;
    }

    public static class State {
        private final int myStartLine1;
        private final int myStartLine2;
        private final int myStartLine3;
        private final int myEndLine1;
        private final int myEndLine2;
        private final int myEndLine3;
        private final boolean myResolved1;
        private final boolean myResolved2;
        private final boolean myOnesideAppliedConflict;

        public State(int startLine1, int startLine2, int startLine3, int endLine1, int endLine2, int endLine3, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict) {
            this.myStartLine1 = startLine1;
            this.myStartLine2 = startLine2;
            this.myStartLine3 = startLine3;
            this.myEndLine1 = endLine1;
            this.myEndLine2 = endLine2;
            this.myEndLine3 = endLine3;
            this.myResolved1 = resolved1;
            this.myResolved2 = resolved2;
            this.myOnesideAppliedConflict = onesideAppliedConflict;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }

    private class MyGutterOperation {
        @NotNull
        private final ThreeSide mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        @NotNull
        private final OperationType myType;
        private boolean myCtrlPressed;
        private boolean myShiftPressed;

        private MyGutterOperation(@NotNull ThreeSide side, @NotNull RangeHighlighter highlighter, OperationType type) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange$MyGutterOperation", "<init>"));
            }
            if (highlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/merge/TextMergeChange$MyGutterOperation", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/merge/TextMergeChange$MyGutterOperation", "<init>"));
            }
            this.mySide = side;
            this.myHighlighter = highlighter;
            this.myType = type;
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != TextMergeChange.this.myViewer.getModifierProvider().isCtrlPressed() || this.myShiftPressed != TextMergeChange.this.myViewer.getModifierProvider().isShiftPressed();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            if (this.mySide == ThreeSide.BASE) {
                return null;
            }
            Side versionSide = (Side)this.mySide.select((Object)Side.LEFT, null, (Object)Side.RIGHT);
            assert (versionSide != null);
            this.myCtrlPressed = TextMergeChange.this.myViewer.getModifierProvider().isCtrlPressed();
            this.myShiftPressed = TextMergeChange.this.myViewer.getModifierProvider().isShiftPressed();
            if (!TextMergeChange.this.isChange(versionSide)) {
                return null;
            }
            switch (this.myType) {
                case APPLY: {
                    return TextMergeChange.this.createApplyRenderer(versionSide, this.myCtrlPressed);
                }
                case IGNORE: {
                    return TextMergeChange.this.createIgnoreRenderer(versionSide, this.myCtrlPressed);
                }
            }
            throw new IllegalArgumentException(this.myType.name());
        }
    }
}

