/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFilesManager {
    private final LogConsoleManager myManager;
    private final List<LogFile> myLogFiles;
    private final SingleAlarm myUpdateAlarm;

    public LogFilesManager(final @NotNull Project project, @NotNull LogConsoleManager manager, @NotNull Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagnostic/logging/LogFilesManager", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/diagnostic/logging/LogFilesManager", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/diagnostic/logging/LogFilesManager", "<init>"));
        }
        this.myLogFiles = new ArrayList<LogFile>();
        this.myManager = manager;
        this.myUpdateAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                for (final LogFile logFile : new ArrayList(LogFilesManager.this.myLogFiles)) {
                    ProcessHandler process = logFile.getProcess();
                    if (process != null && process.isProcessTerminated()) {
                        LogFilesManager.this.myLogFiles.remove(logFile);
                        continue;
                    }
                    final Set<String> oldPaths = logFile.getPaths();
                    final Set newPaths = logFile.getOptions().getPaths();
                    logFile.setPaths(newPaths);
                    THashSet obsoletePaths = new THashSet(oldPaths);
                    obsoletePaths.removeAll(newPaths);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable((Set)obsoletePaths){
                            final /* synthetic */ Set val$obsoletePaths;
                            {
                                this.val$obsoletePaths = set3;
                            }

                            @Override
                            public void run() {
                                if (project.isDisposed()) {
                                    return;
                                }
                                LogFilesManager.this.addConfigurationConsoles(logFile.getOptions(), (Condition<String>)((Condition)new Condition<String>(){

                                    public boolean value(String file2) {
                                        return !oldPaths.contains(file2);
                                    }
                                }), newPaths, logFile.getConfiguration());
                                for (String each : this.val$obsoletePaths) {
                                    LogFilesManager.this.myManager.removeLogConsole(each);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
                if (!LogFilesManager.this.myLogFiles.isEmpty() && !LogFilesManager.this.myUpdateAlarm.isDisposed()) {
                    LogFilesManager.this.myUpdateAlarm.request();
                }
            }
        }, 500, Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public void addLogConsoles(@NotNull RunConfigurationBase runConfiguration, @Nullable ProcessHandler startedProcess) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/diagnostic/logging/LogFilesManager", "addLogConsoles"));
        }
        for (LogFileOptions logFileOptions : runConfiguration.getAllLogFiles()) {
            if (!logFileOptions.isEnabled()) continue;
            this.myLogFiles.add(new LogFile(logFileOptions, runConfiguration, startedProcess));
        }
        this.myUpdateAlarm.request();
        runConfiguration.createAdditionalTabComponents((AdditionalTabComponentManager)this.myManager, startedProcess);
    }

    private void addConfigurationConsoles(@NotNull LogFileOptions logFile, @NotNull Condition<String> shouldInclude, @NotNull Set<String> paths, @NotNull RunConfigurationBase runConfiguration) {
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (shouldInclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldInclude", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (paths.isEmpty()) {
            return;
        }
        TreeMap<String, String> titleToPath = new TreeMap<String, String>();
        if (paths.size() == 1) {
            String path = paths.iterator().next();
            if (shouldInclude.value((Object)path)) {
                titleToPath.put(logFile.getName(), path);
            }
        } else {
            for (String path : paths) {
                if (!shouldInclude.value((Object)path)) continue;
                String title = new File(path).getName();
                if (titleToPath.containsKey(title)) {
                    title = path;
                }
                titleToPath.put(title, path);
            }
        }
        for (String title : titleToPath.keySet()) {
            String path = (String)titleToPath.get(title);
            assert (path != null);
            this.myManager.addLogConsole(title, path, logFile.getCharset(), logFile.isSkipContent() ? new File(path).length() : 0L, runConfiguration);
        }
    }

    private static class LogFile {
        private final LogFileOptions myOptions;
        private final RunConfigurationBase myConfiguration;
        private final ProcessHandler myProcess;
        private Set<String> myPaths = new HashSet<String>();

        public LogFile(LogFileOptions options, RunConfigurationBase configuration, ProcessHandler process) {
            this.myOptions = options;
            this.myConfiguration = configuration;
            this.myProcess = process;
        }

        public LogFileOptions getOptions() {
            return this.myOptions;
        }

        public RunConfigurationBase getConfiguration() {
            return this.myConfiguration;
        }

        public ProcessHandler getProcess() {
            return this.myProcess;
        }

        public Set<String> getPaths() {
            return this.myPaths;
        }

        public void setPaths(Set<String> paths) {
            this.myPaths = paths;
        }
    }
}

