/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.LogMessage;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

class PluginErrorNotifications {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Plugin Errors", NotificationDisplayType.STICKY_BALLOON, true);
    private static final Set<String> myPluginsShowing = new HashSet();

    private PluginErrorNotifications() {
    }

    static void maybeNotifyUi(@NotNull LogMessage message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diagnostic/PluginErrorNotifications", "maybeNotifyUi"));
        }
        final PluginId pluginId = IdeErrorsDialog.findPluginId(message.getThrowable());
        if (pluginId == null || myPluginsShowing.contains(pluginId.getIdString()) || PluginManager.getPlugin(pluginId).isBundled()) {
            return;
        }
        myPluginsShowing.add(pluginId.getIdString());
        String title = "Plugin Error";
        String notificationText = String.format("%s threw an uncaught %s. <a href='xxx'>Disable Plugin</a>", PluginManager.getPlugin(pluginId).getName(), message.getThrowable().getClass().getSimpleName());
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/diagnostic/PluginErrorNotifications$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/PluginErrorNotifications$1", "hyperlinkUpdate"));
                }
                IdeErrorsDialog.disablePlugin(pluginId);
            }
        };
        Notification notification = new Notification(NOTIFICATION_GROUP.getDisplayId(), title, notificationText, NotificationType.ERROR, listener){

            public void expire() {
                super.expire();
                myPluginsShowing.remove(pluginId.getIdString());
            }
        };
        notification.notify(null);
        message.setNotification(notification);
    }
}

