/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.clipboard;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class SimpleTransferable
implements Transferable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.designer.clipboard.SimpleTransferable");
    private final Object myData;
    private final DataFlavor myFlavor;

    public SimpleTransferable(Object data, DataFlavor flavor) {
        this.myData = data;
        this.myFlavor = flavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        try {
            return new DataFlavor[]{this.myFlavor};
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return new DataFlavor[0];
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        try {
            return this.myFlavor.equals(flavor);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return false;
        }
    }

    @Override
    @Nullable
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        try {
            if (!this.myFlavor.equals(flavor)) {
                return null;
            }
            return this.myData;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <T> T getData(Transferable transferable, Class<T> dataClass) {
        try {
            for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                Object transferData;
                if (!transferable.isDataFlavorSupported(dataFlavor) || !dataClass.isInstance(transferData = transferable.getTransferData(dataFlavor))) continue;
                return (T)transferData;
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }
}

