/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.DefaultMethodInvoker;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.MethodEvaluator");
    private final JVMName myClassName;
    private final JVMName myMethodSignature;
    private final String myMethodName;
    private final Evaluator[] myArgumentEvaluators;
    private final Evaluator myObjectEvaluator;
    private final boolean myCheckDefaultInterfaceMethod;
    private final boolean myMustBeVararg;

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators) {
        this(objectEvaluator, className, methodName, signature, argumentEvaluators, false, false);
    }

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators, boolean checkDefaultInterfaceMethod, boolean mustBeVararg) {
        this.myObjectEvaluator = new DisableGC(objectEvaluator);
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myMethodSignature = signature;
        this.myArgumentEvaluators = argumentEvaluators;
        this.myCheckDefaultInterfaceMethod = checkDefaultInterfaceMethod;
        this.myMustBeVararg = mustBeVararg;
    }

    @Override
    public Modifier getModifier() {
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        boolean requiresSuperObject = this.myObjectEvaluator instanceof SuperEvaluator || this.myObjectEvaluator instanceof DisableGC && ((DisableGC)this.myObjectEvaluator).getDelegate() instanceof SuperEvaluator;
        Object object = this.myObjectEvaluator.evaluate(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MethodEvaluator: object = " + object);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !MethodEvaluator.isInvokableType(object)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.myMethodName}));
        }
        ArrayList<Object> args = new ArrayList<Object>(this.myArgumentEvaluators.length);
        for (Evaluator evaluator : this.myArgumentEvaluators) {
            args.add(evaluator.evaluate(context));
        }
        try {
            int retTypePos;
            ReferenceType referenceType = null;
            if (object instanceof ObjectReference) {
                referenceType = ((ObjectReference)object).referenceType();
            } else if (MethodEvaluator.isInvokableType(object)) {
                referenceType = debugProcess.findClass(context, ((ReferenceType)object).name(), context.getClassLoader());
            } else {
                String className;
                String string = className = this.myClassName != null ? this.myClassName.getName(debugProcess) : null;
                if (className != null) {
                    referenceType = debugProcess.findClass(context, className, context.getClassLoader());
                }
            }
            if (referenceType == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.myMethodName})));
            }
            String signature = this.myMethodSignature != null ? this.myMethodSignature.getName(debugProcess) : null;
            String methodName = DebuggerUtilsEx.methodName(referenceType.name(), this.myMethodName, signature);
            if (MethodEvaluator.isInvokableType(object)) {
                if (MethodEvaluator.isInvokableType(referenceType)) {
                    Method jdiMethod = signature != null ? (referenceType instanceof ClassType ? ((ClassType)referenceType).concreteMethodByName(this.myMethodName, signature) : (Method)ContainerUtil.getFirstItem(referenceType.methodsByName(this.myMethodName, signature))) : (Method)ContainerUtil.getFirstItem(referenceType.methodsByName(this.myMethodName));
                    if (jdiMethod != null && jdiMethod.isStatic()) {
                        if (referenceType instanceof ClassType) {
                            return debugProcess.invokeMethod((EvaluationContext)context, (ClassType)referenceType, jdiMethod, args);
                        }
                        return debugProcess.invokeMethod((EvaluationContext)context, (InterfaceType)referenceType, jdiMethod, args);
                    }
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{methodName}));
            }
            ObjectReference objRef = (ObjectReference)object;
            ReferenceType _refType = referenceType;
            if (requiresSuperObject && referenceType instanceof ClassType) {
                _refType = ((ClassType)referenceType).superclass();
            }
            Method jdiMethod = DebuggerUtils.findMethod((ReferenceType)_refType, (String)this.myMethodName, (String)signature);
            if (signature == null) {
                if (jdiMethod == null || jdiMethod.argumentTypeNames().size() != args.size()) {
                    for (Method method : _refType.methodsByName(this.myMethodName)) {
                        if (method.argumentTypeNames().size() != args.size()) continue;
                        jdiMethod = method;
                        break;
                    }
                }
            } else if (this.myMustBeVararg && jdiMethod != null && !jdiMethod.isVarArgs() && jdiMethod.isBridge() && (retTypePos = signature.lastIndexOf(")")) >= 0) {
                String signatureNoRetType = signature.substring(0, retTypePos + 1);
                for (Method method : _refType.visibleMethods()) {
                    if (!method.name().equals(this.myMethodName) || !method.signature().startsWith(signatureNoRetType) || method.isBridge() || method.isAbstract()) continue;
                    jdiMethod = method;
                    break;
                }
            }
            if (jdiMethod == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{methodName}));
            }
            if (requiresSuperObject) {
                return debugProcess.invokeInstanceMethod(context, objRef, jdiMethod, args, 2);
            }
            if (Patches.JDK_BUG_ID_8042123 && this.myCheckDefaultInterfaceMethod && jdiMethod.declaringType() instanceof InterfaceType) {
                try {
                    return MethodEvaluator.invokeDefaultMethod(debugProcess, context, objRef, this.myMethodName);
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
            }
            return debugProcess.invokeMethod((EvaluationContext)context, objRef, jdiMethod, args);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    private static boolean isInvokableType(Object type) {
        return type instanceof ClassType || type instanceof InterfaceType;
    }

    private static Value invokeDefaultMethod(DebugProcess debugProcess, EvaluationContext evaluationContext, Value obj, String name) throws EvaluateException {
        List<Method> methods;
        ClassType invokerClass = ClassLoadingUtils.getHelperClass(DefaultMethodInvoker.class.getName(), evaluationContext, debugProcess);
        if (invokerClass != null && !(methods = invokerClass.methodsByName("invoke")).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext, invokerClass, methods.get(0), Arrays.asList(obj, ((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(name)));
        }
        return null;
    }

    public String toString() {
        return "call " + this.myMethodName;
    }
}

