/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ComparingClassifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ForceableComparable;
import com.intellij.util.ProcessingContext;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CachingComparingClassifier
extends ComparingClassifier<LookupElement> {
    private final Map<LookupElement, Comparable> myWeights = new IdentityHashMap<LookupElement, Comparable>();
    private final LookupElementWeigher myWeigher;
    private Ref<Comparable> myFirstWeight;
    private boolean myPrimitive = true;
    private int myPrefixChanges = -1;

    public CachingComparingClassifier(Classifier<LookupElement> next, LookupElementWeigher weigher) {
        super(next, weigher.toString(), weigher.isNegated());
        this.myWeigher = weigher;
    }

    @Override
    @Nullable
    public final Comparable getWeight(LookupElement element, ProcessingContext context) {
        Comparable w = this.myWeights.get(element);
        if (w == null && this.myWeigher.isPrefixDependent()) {
            w = this.myWeigher.weigh(element, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT));
            this.myWeights.put(element, w);
        }
        return w;
    }

    @Override
    public void removeElement(LookupElement element, ProcessingContext context) {
        this.myWeights.remove(element);
        super.removeElement(element, context);
    }

    @Override
    public Iterable<LookupElement> classify(Iterable<LookupElement> source, ProcessingContext context) {
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            return this.myNext.classify(source, context);
        }
        this.checkPrefixChanged(context);
        return super.classify(source, context);
    }

    private void checkPrefixChanged(ProcessingContext context) {
        int actualPrefixChanges = (Integer)context.get(CompletionLookupArranger.PREFIX_CHANGES);
        if (this.myWeigher.isPrefixDependent() && this.myPrefixChanges != actualPrefixChanges) {
            this.myPrefixChanges = actualPrefixChanges;
            this.myWeights.clear();
        }
    }

    @Override
    public void describeItems(LinkedHashMap<LookupElement, StringBuilder> map, ProcessingContext context) {
        this.checkPrefixChanged(context);
        super.describeItems(map, context);
    }

    @Override
    public void addElement(LookupElement t, ProcessingContext context) {
        Comparable weight = this.myWeigher.weigh(t, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT));
        if (weight instanceof ForceableComparable) {
            ((ForceableComparable)weight).force();
        }
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            if (this.myFirstWeight == null) {
                this.myFirstWeight = Ref.create((Object)weight);
            } else if (!Comparing.equal((Object)this.myFirstWeight.get(), (Object)weight)) {
                this.myPrimitive = false;
            }
        }
        this.myWeights.put(t, weight);
        super.addElement(t, context);
    }
}

