/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalVarFromInstanceofAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCastExpressionFromInstanceofAction
extends CreateLocalVarFromInstanceofAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction", "isAvailable"));
        }
        boolean available = super.isAvailable(project, editor, file2);
        if (!available) {
            return false;
        }
        PsiInstanceOfExpression instanceOfExpression = CreateCastExpressionFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file2);
        if (instanceOfExpression == null) {
            return false;
        }
        PsiTypeElement checkType = instanceOfExpression.getCheckType();
        if (checkType == null) {
            return false;
        }
        PsiType type = checkType.getType();
        String castTo = type.getPresentableText();
        this.setText(CodeInsightBundle.message((String)"cast.to.0", (Object[])new Object[]{castTo}));
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiInstanceOfExpression instanceOfExpression = CreateCastExpressionFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file2);
        assert (instanceOfExpression.getContainingFile() == file2) : instanceOfExpression.getContainingFile() + "; file=" + file2;
        PsiElement decl = CreateCastExpressionFromInstanceofAction.createAndInsertCast(instanceOfExpression, editor, file2);
        if (decl == null) {
            return;
        }
        decl = CodeStyleManager.getInstance((Project)project).reformat(CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(decl));
        editor.getCaretModel().moveToOffset(decl.getTextRange().getEndOffset());
    }

    @Nullable
    private static PsiElement createAndInsertCast(PsiInstanceOfExpression instanceOfExpression, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiStatement statementInside;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)instanceOfExpression.getProject()).getElementFactory();
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("((a)b)", (PsiElement)instanceOfExpression);
        PsiParenthesizedExpression paren = (PsiParenthesizedExpression)statement.getExpression();
        PsiTypeCastExpression cast = (PsiTypeCastExpression)paren.getExpression();
        PsiType castType = instanceOfExpression.getCheckType().getType();
        cast.getCastType().replace((PsiElement)factory.createTypeElement(castType));
        cast.getOperand().replace((PsiElement)instanceOfExpression.getOperand());
        PsiStatement psiStatement = statementInside = CreateCastExpressionFromInstanceofAction.isNegated(instanceOfExpression) ? null : CreateCastExpressionFromInstanceofAction.getExpressionStatementInside(file2, editor, instanceOfExpression.getOperand());
        if (statementInside != null) {
            return statementInside.replace((PsiElement)statement);
        }
        return CreateCastExpressionFromInstanceofAction.insertAtAnchor(instanceOfExpression, (PsiElement)statement);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"cast.expression", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction", "getFamilyName"));
        }
        return string;
    }
}

