/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.simple;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;

public class BracesTailType
extends TailType {
    public int processTail(Editor editor, int tailOffset) {
        int startOffset = tailOffset;
        CharSequence seq = editor.getDocument().getCharsSequence();
        int nextNonWs = CharArrayUtil.shiftForward((CharSequence)seq, (int)tailOffset, (String)" \t");
        tailOffset = nextNonWs < seq.length() && seq.charAt(nextNonWs) == '{' ? nextNonWs + 1 : BracesTailType.insertChar((Editor)editor, (int)startOffset, (char)'{');
        if (EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, tailOffset = BracesTailType.reformatBrace(editor, tailOffset, startOffset), BracesTailType.getFileType((Editor)editor))) {
            new EnterHandler(EditorActionManager.getInstance().getActionHandler("EditorEnter")).executeWriteAction(editor, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
            return editor.getCaretModel().getOffset();
        }
        return tailOffset;
    }

    private static int reformatBrace(Editor editor, int tailOffset, int startOffset) {
        PsiFile psiFile;
        Project project = editor.getProject();
        if (project != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            editor.getCaretModel().moveToOffset(tailOffset);
            CodeStyleManager.getInstance((Project)project).reformatText(psiFile, startOffset, tailOffset);
            tailOffset = editor.getCaretModel().getOffset();
        }
        return tailOffset;
    }
}

