/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionThreading;
import com.intellij.codeInsight.completion.WeighingDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class AsyncCompletion
implements CompletionThreading {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AsyncCompletion");

    AsyncCompletion() {
    }

    @Override
    public Future<?> startThread(final ProgressIndicator progressIndicator, final Runnable runnable2) {
        final Semaphore startSemaphore = new Semaphore();
        startSemaphore.down();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    startSemaphore.up();
                                    ProgressManager.checkCanceled();
                                    runnable2.run();
                                }
                            });
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                    }
                }, progressIndicator);
            }
        });
        startSemaphore.waitFor();
        return future2;
    }

    @Override
    public WeighingDelegate delegateWeighing(final CompletionProgressIndicator indicator) {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        class WeighItems
        implements Runnable {
            WeighItems() {
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        Computable next;
                        if ((next = (Computable)queue.poll(30L, TimeUnit.MILLISECONDS)) != null && !((Boolean)next.compute()).booleanValue()) {
                            indicator.addDelayedMiddleMatches();
                            return;
                        }
                        indicator.checkCanceled();
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                    return;
                }
            }
        }
        final Future<?> future2 = this.startThread(ProgressWrapper.wrap(indicator), new WeighItems());
        return new WeighingDelegate(){

            @Override
            public void waitFor() {
                queue.offer(new Computable.PredefinedValueComputable((Object)false));
                try {
                    future2.get();
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void consume(final CompletionResult result2) {
                queue.offer(new Computable<Boolean>(){

                    public Boolean compute() {
                        indicator.addItem(result2);
                        return true;
                    }
                });
            }
        };
    }
}

