/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.ImmutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.ImmutableJarInput;
import com.android.build.gradle.internal.pipeline.ImmutableTransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.MutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.QualifiedContentImpl;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OriginalStream
extends TransformStream {
    private static Supplier<Collection<File>> EMPTY_SUPPLIER = new Supplier<Collection<File>>(){

        public Collection<File> get() {
            return ImmutableList.of();
        }
    };
    private final Supplier<Collection<File>> jarFiles;
    private final Supplier<Collection<File>> folders;

    public static Builder builder() {
        return new Builder();
    }

    private OriginalStream(Set<QualifiedContent.ContentType> contentTypes, QualifiedContent.Scope scope, Supplier<Collection<File>> jarFiles, Supplier<Collection<File>> folders, List<? extends Object> dependencies) {
        super(contentTypes, (Set<QualifiedContent.Scope>)Sets.immutableEnumSet((Enum)scope, (Enum[])new QualifiedContent.Scope[0]), dependencies);
        this.jarFiles = jarFiles;
        this.folders = folders;
    }

    @Override
    List<File> getInputFiles() {
        Collection list1 = (Collection)this.jarFiles.get();
        Collection list2 = (Collection)this.folders.get();
        ArrayList inputFiles = Lists.newArrayListWithCapacity((int)(list1.size() + list2.size()));
        inputFiles.addAll(list1);
        inputFiles.addAll(list2);
        return inputFiles;
    }

    @Override
    TransformInput asNonIncrementalInput() {
        ArrayList jarInputs = Lists.newArrayList();
        ArrayList directoryInputs = Lists.newArrayList();
        Set<QualifiedContent.ContentType> contentTypes = this.getContentTypes();
        Set<QualifiedContent.Scope> scopes = this.getScopes();
        for (File file : (Collection)this.jarFiles.get()) {
            jarInputs.add(new ImmutableJarInput(OriginalStream.getUniqueInputName(file), file, Status.NOTCHANGED, contentTypes, scopes));
        }
        for (File file : (Collection)this.folders.get()) {
            directoryInputs.add(new ImmutableDirectoryInput(OriginalStream.getUniqueInputName(file), file, contentTypes, scopes));
        }
        return new ImmutableTransformInput(jarInputs, directoryInputs, null);
    }

    @Override
    IncrementalTransformInput asIncrementalInput() {
        OriginalTransformInput input = new OriginalTransformInput();
        Set<QualifiedContent.ContentType> contentTypes = this.getContentTypes();
        Set<QualifiedContent.Scope> scopes = this.getScopes();
        for (File file : (Collection)this.jarFiles.get()) {
            input.addJarInput(new QualifiedContentImpl(OriginalStream.getUniqueInputName(file), file, contentTypes, scopes));
        }
        for (File file : (Collection)this.folders.get()) {
            input.addFolderInput(new MutableDirectoryInput(OriginalStream.getUniqueInputName(file), file, contentTypes, scopes));
        }
        return input;
    }

    private static String getUniqueInputName(File file) {
        return Hashing.sha1().hashString((CharSequence)file.getPath(), Charsets.UTF_16LE).toString();
    }

    @Override
    TransformStream makeRestrictedCopy(Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
        if (!((Object)scopes).equals(this.getScopes())) {
            throw new UnsupportedOperationException("Cannot do a scope-restricted OriginalStream");
        }
        return new OriginalStream(types, (QualifiedContent.Scope)Iterables.getOnlyElement(scopes), this.jarFiles, this.folders, this.getDependencies());
    }

    Supplier<Collection<File>> getJarFiles() {
        return this.jarFiles;
    }

    Supplier<Collection<File>> getFolders() {
        return this.folders;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("jarFiles", this.jarFiles.get()).add("folders", this.folders.get()).add("scopes", this.getScopes()).add("contentTypes", this.getContentTypes()).add("dependencies", this.getDependencies()).toString();
    }

    private static class OriginalTransformInput
    extends IncrementalTransformInput {
        private OriginalTransformInput() {
        }

        @Override
        protected boolean checkRemovedFolder(File file, List<String> fileSegments) {
            return false;
        }

        @Override
        boolean checkRemovedJarFile(File file, List<String> fileSegments) {
            return false;
        }
    }

    public static final class Builder {
        private Set<QualifiedContent.ContentType> contentTypes = Sets.newHashSet();
        private QualifiedContent.Scope scope;
        private Supplier<Collection<File>> jarFiles;
        private Supplier<Collection<File>> folders;
        private List<? extends Object> dependencies;

        public OriginalStream build() {
            Preconditions.checkNotNull((Object)this.scope);
            Preconditions.checkState((!this.contentTypes.isEmpty() ? 1 : 0) != 0);
            return new OriginalStream((Set)ImmutableSet.copyOf(this.contentTypes), this.scope, this.jarFiles != null ? this.jarFiles : EMPTY_SUPPLIER, this.folders != null ? this.folders : EMPTY_SUPPLIER, this.dependencies != null ? this.dependencies : ImmutableList.of());
        }

        public Builder addContentTypes(Set<QualifiedContent.ContentType> types) {
            this.contentTypes.addAll(types);
            return this;
        }

        public Builder addContentTypes(QualifiedContent.ContentType ... types) {
            this.contentTypes.addAll(Arrays.asList(types));
            return this;
        }

        public Builder addContentType(QualifiedContent.ContentType type) {
            this.contentTypes.add(type);
            return this;
        }

        public Builder addScope(QualifiedContent.Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder setJar(File jarFile) {
            this.jarFiles = Suppliers.ofInstance((Object)ImmutableList.of((Object)jarFile));
            return this;
        }

        public Builder setJars(Supplier<Collection<File>> jarSupplier) {
            this.jarFiles = jarSupplier;
            return this;
        }

        public Builder setFolder(File folder) {
            this.folders = Suppliers.ofInstance((Object)ImmutableList.of((Object)folder));
            return this;
        }

        public Builder setFolders(Supplier<Collection<File>> folderSupplier) {
            this.folders = folderSupplier;
            return this;
        }

        public Builder setDependencies(List<? extends Object> dependencies) {
            this.dependencies = ImmutableList.copyOf(dependencies);
            return this;
        }

        public Builder setDependency(Object dependency) {
            this.dependencies = ImmutableList.of((Object)dependency);
            return this;
        }
    }
}

