/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.internal.BiAction;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.dsl.internal.inputs.RuleInputAccessBacking;
import org.gradle.model.dsl.internal.transform.InputReferences;
import org.gradle.model.dsl.internal.transform.RuleMetadata;
import org.gradle.model.dsl.internal.transform.RulesBlock;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreatorFactory;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class TransformedModelDslBacking {
    private static final Transformer<InputReferences, Closure<?>> INPUT_PATHS_EXTRACTOR = new Transformer<InputReferences, Closure<?>>(){

        public InputReferences transform(Closure<?> closure) {
            InputReferences inputs = new InputReferences();
            RuleMetadata ruleMetadata = TransformedModelDslBacking.getRuleMetadata(closure);
            inputs.absolutePaths(ruleMetadata.absoluteInputPaths(), ruleMetadata.absoluteInputLineNumbers());
            inputs.relativePaths(ruleMetadata.relativeInputPaths(), ruleMetadata.relativeInputLineNumbers());
            return inputs;
        }
    };
    private static final Transformer<SourceLocation, Closure<?>> RULE_LOCATION_EXTRACTOR = new Transformer<SourceLocation, Closure<?>>(){

        public SourceLocation transform(Closure<?> closure) {
            RuleMetadata ruleMetadata = TransformedModelDslBacking.getRuleMetadata(closure);
            return new SourceLocation(ruleMetadata.scriptSourceDescription(), ruleMetadata.lineNumber(), ruleMetadata.columnNumber());
        }
    };
    private final ModelRegistry modelRegistry;
    private final Transformer<? extends InputReferences, ? super Closure<?>> inputPathsExtractor;
    private final Transformer<SourceLocation, ? super Closure<?>> ruleLocationExtractor;
    private final ModelSchemaStore schemaStore;
    private final ModelCreatorFactory modelCreatorFactory;

    public TransformedModelDslBacking(ModelRegistry modelRegistry, ModelSchemaStore schemaStore, ModelCreatorFactory modelCreatorFactory) {
        this(modelRegistry, schemaStore, modelCreatorFactory, INPUT_PATHS_EXTRACTOR, RULE_LOCATION_EXTRACTOR);
    }

    TransformedModelDslBacking(ModelRegistry modelRegistry, ModelSchemaStore schemaStore, ModelCreatorFactory modelCreatorFactory, Transformer<? extends InputReferences, ? super Closure<?>> inputPathsExtractor, Transformer<SourceLocation, ? super Closure<?>> ruleLocationExtractor) {
        this.modelRegistry = modelRegistry;
        this.schemaStore = schemaStore;
        this.modelCreatorFactory = modelCreatorFactory;
        this.inputPathsExtractor = inputPathsExtractor;
        this.ruleLocationExtractor = ruleLocationExtractor;
    }

    public void configure(String modelPathString, Closure<?> closure) {
        SourceLocation sourceLocation = (SourceLocation)this.ruleLocationExtractor.transform(closure);
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        ModelRuleDescriptor descriptor = this.toDescriptor(sourceLocation, modelPath);
        this.registerAction(modelPath, Object.class, descriptor, ModelActionRole.Mutate, closure);
    }

    public <T> void create(String modelPathString, @DelegatesTo.Target Class<T> type, @DelegatesTo(genericTypeIndex=0) Closure<?> closure) {
        SourceLocation sourceLocation = (SourceLocation)this.ruleLocationExtractor.transform(closure);
        ModelPath modelPath = ModelPath.path((String)modelPathString);
        ModelSchema schema = this.schemaStore.getSchema(ModelType.of(type));
        ModelRuleDescriptor descriptor = this.toDescriptor(sourceLocation, modelPath);
        if (!schema.getKind().isManaged()) {
            throw new InvalidModelRuleDeclarationException(descriptor, "Cannot create an element of type " + type.getName() + " as it is not a managed type");
        }
        ModelCreator creator = this.modelCreatorFactory.creator(descriptor, modelPath, schema);
        this.modelRegistry.create(creator);
        this.registerAction(modelPath, type, descriptor, ModelActionRole.Initialize, closure);
    }

    private <T> void registerAction(ModelPath modelPath, Class<T> viewType, final ModelRuleDescriptor descriptor, final ModelActionRole role, final Closure<?> closure) {
        final ModelReference reference = ModelReference.of((ModelPath)modelPath, viewType);
        ModelAction action = DirectNodeNoInputsModelAction.of((ModelReference)reference, (ModelRuleDescriptor)descriptor, (Action)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                String description;
                int i;
                InputReferences inputs = (InputReferences)TransformedModelDslBacking.this.inputPathsExtractor.transform((Object)closure);
                List<String> absolutePaths = inputs.getAbsolutePaths();
                List<Integer> absolutePathLineNumbers = inputs.getAbsolutePathLineNumbers();
                List<String> relativePaths = inputs.getRelativePaths();
                List<Integer> relativePathLineNumbers = inputs.getRelativePathLineNumbers();
                ArrayList references = Lists.newArrayListWithCapacity((int)(absolutePaths.size() + inputs.getRelativePaths().size()));
                for (i = 0; i < absolutePaths.size(); ++i) {
                    description = String.format("@ line %d", absolutePathLineNumbers.get(i));
                    references.add(ModelReference.untyped((ModelPath)ModelPath.path((String)absolutePaths.get(i)), (String)description));
                }
                for (i = 0; i < relativePaths.size(); ++i) {
                    description = String.format("@ line %d", relativePathLineNumbers.get(i));
                    references.add(ModelReference.untyped((ModelPath)ModelPath.path((String)relativePaths.get(i)), (String)description));
                }
                InputUsingModelAction runClosureAction = InputUsingModelAction.of((ModelReference)reference, (ModelRuleDescriptor)descriptor, (List)references, new ExecuteClosure(closure));
                TransformedModelDslBacking.this.modelRegistry.configure(role, (ModelAction)runClosureAction);
            }
        });
        this.modelRegistry.configure(ModelActionRole.DefineRules, action);
    }

    public ModelRuleDescriptor toDescriptor(SourceLocation sourceLocation, ModelPath modelPath) {
        return sourceLocation.asDescriptor("model." + modelPath);
    }

    private static RuleMetadata getRuleMetadata(Closure<?> closure) {
        RuleMetadata ruleMetadata = closure.getClass().getAnnotation(RuleMetadata.class);
        if (ruleMetadata == null) {
            throw new IllegalStateException(String.format("Expected %s annotation to be used on the argument closure.", RuleMetadata.class.getName()));
        }
        return ruleMetadata;
    }

    public static boolean isTransformedBlock(Closure<?> closure) {
        Class<?> closureClass = closure.getClass();
        RulesBlock annotation = closureClass.getAnnotation(RulesBlock.class);
        return annotation != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecuteClosure<T>
    implements BiAction<T, List<ModelView<?>>> {
        private final Closure<?> closure;

        public ExecuteClosure(Closure<?> closure) {
            this.closure = closure.rehydrate(null, null, null);
        }

        public void execute(final T object, List<ModelView<?>> inputs) {
            RuleInputAccessBacking.runWithContext(inputs, new Runnable(){

                public void run() {
                    new ClosureBackedAction(ExecuteClosure.this.closure).execute(object);
                }
            });
        }
    }
}

