/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers;

import com.android.tools.ndk.run.lldb.renderers.ConstTypeNameFormatter;
import com.android.utils.Pair;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNameFormatterCategory {
    private static final HashMap<String, TypeNameFormatterCategory> myTypeNameFormatterCategories = new HashMap();
    private final String myName;
    private final HashMap<String, PatternFormatterPair> myTypeNameFormatterMap;
    private static final Logger LOG = Logger.getInstance(TypeNameFormatterCategory.class);

    @NotNull
    public static TypeNameFormatterCategory createTypeNameFormatterCategory(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "createTypeNameFormatterCategory"));
        }
        TypeNameFormatterCategory category = myTypeNameFormatterCategories.get(name);
        if (category != null) {
            TypeNameFormatterCategory typeNameFormatterCategory = category;
            if (typeNameFormatterCategory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "createTypeNameFormatterCategory"));
            }
            return typeNameFormatterCategory;
        }
        category = new TypeNameFormatterCategory(name);
        myTypeNameFormatterCategories.put(name, category);
        TypeNameFormatterCategory typeNameFormatterCategory = category;
        if (typeNameFormatterCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "createTypeNameFormatterCategory"));
        }
        return typeNameFormatterCategory;
    }

    @Nullable
    public static TypeNameFormatter lookupTypeNameFormatter(@NotNull String rawTypeName) {
        if (rawTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawTypeName", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "lookupTypeNameFormatter"));
        }
        for (Map.Entry<String, TypeNameFormatterCategory> entry : myTypeNameFormatterCategories.entrySet()) {
            TypeNameFormatter formatter = entry.getValue().getTypeNameFormatter(rawTypeName);
            if (formatter == null) continue;
            return formatter;
        }
        return null;
    }

    public TypeNameFormatterCategory(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "<init>"));
        }
        this.myName = name;
        this.myTypeNameFormatterMap = new HashMap();
    }

    public void registerTypeNameFormatter(@NotNull String name, @NotNull Pattern pattern, @NotNull TypeNameFormatter formatter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "registerTypeNameFormatter"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "registerTypeNameFormatter"));
        }
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "registerTypeNameFormatter"));
        }
        if (this.myTypeNameFormatterMap.get(name) != null) {
            LOG.warn(String.format("Overwriting the type-name-formatter with name %s.", name));
        }
        this.myTypeNameFormatterMap.put(name, new PatternFormatterPair(pattern, formatter));
    }

    @Nullable
    private TypeNameFormatter getTypeNameFormatter(@NotNull String rawTypeName) {
        if (rawTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawTypeName", "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory", "getTypeNameFormatter"));
        }
        Pair<String, Boolean> nonConstTypeNamePair = ConstTypeNameFormatter.getNonConstTypeName(rawTypeName);
        for (Map.Entry<String, PatternFormatterPair> mapEntry : this.myTypeNameFormatterMap.entrySet()) {
            PatternFormatterPair pair = mapEntry.getValue();
            Matcher matcher = pair.pattern.matcher((CharSequence)nonConstTypeNamePair.getFirst());
            if (!matcher.find()) continue;
            if (((Boolean)nonConstTypeNamePair.getSecond()).booleanValue()) {
                return new ConstTypeNameFormatter(pair.formatter);
            }
            return pair.formatter;
        }
        return null;
    }

    private static class PatternFormatterPair {
        public final Pattern pattern;
        public final TypeNameFormatter formatter;

        public PatternFormatterPair(Pattern p, TypeNameFormatter f) {
            this.pattern = p;
            this.formatter = f;
        }
    }

    public static interface TypeNameFormatter {
        public String format(String var1);
    }
}

