/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.automata;

import com.google.repacked.antlr.v4.runtime.atn.ATN;
import com.google.repacked.antlr.v4.runtime.atn.ATNState;
import com.google.repacked.antlr.v4.runtime.atn.AtomTransition;
import com.google.repacked.antlr.v4.runtime.atn.BlockEndState;
import com.google.repacked.antlr.v4.runtime.atn.DecisionState;
import com.google.repacked.antlr.v4.runtime.atn.EpsilonTransition;
import com.google.repacked.antlr.v4.runtime.atn.NotSetTransition;
import com.google.repacked.antlr.v4.runtime.atn.RangeTransition;
import com.google.repacked.antlr.v4.runtime.atn.SetTransition;
import com.google.repacked.antlr.v4.runtime.atn.Transition;
import com.google.repacked.antlr.v4.runtime.misc.Interval;
import com.google.repacked.antlr.v4.runtime.misc.IntervalSet;
import com.google.repacked.antlr.v4.runtime.misc.NotNull;
import com.google.repacked.antlr.v4.tool.Grammar;
import com.google.repacked.antlr.v4.tool.Rule;
import java.util.List;

public class ATNOptimizer {
    public static void optimize(@NotNull Grammar g, @NotNull ATN atn) {
        ATNOptimizer.optimizeSets(g, atn);
        ATNOptimizer.optimizeStates(atn);
    }

    private static void optimizeSets(Grammar g, ATN atn) {
        if (g.isParser()) {
            return;
        }
        int removedStates = 0;
        List<DecisionState> decisions = atn.decisionToState;
        for (DecisionState decision : decisions) {
            int i;
            if (decision.ruleIndex >= 0) {
                Rule rule = g.getRule(decision.ruleIndex);
                if (Character.isLowerCase(rule.name.charAt(0))) continue;
            }
            IntervalSet setTransitions = new IntervalSet(new int[0]);
            for (i = 0; i < decision.getNumberOfTransitions(); ++i) {
                Transition epsTransition = decision.transition(i);
                if (!(epsTransition instanceof EpsilonTransition) || epsTransition.target.getNumberOfTransitions() != 1) continue;
                Transition transition = epsTransition.target.transition(0);
                if (!(transition.target instanceof BlockEndState) || transition instanceof NotSetTransition || !(transition instanceof AtomTransition) && !(transition instanceof RangeTransition) && !(transition instanceof SetTransition)) continue;
                setTransitions.add(i);
            }
            for (i = setTransitions.getIntervals().size() - 1; i >= 0; --i) {
                Transition newTransition;
                Interval interval = setTransitions.getIntervals().get(i);
                if (interval.length() <= 1) continue;
                ATNState blockEndState = decision.transition((int)interval.a).target.transition((int)0).target;
                IntervalSet matchSet = new IntervalSet(new int[0]);
                for (int j = interval.a; j <= interval.b; ++j) {
                    Transition matchTransition = decision.transition((int)j).target.transition(0);
                    if (matchTransition instanceof NotSetTransition) {
                        throw new UnsupportedOperationException("Not yet implemented.");
                    }
                    matchSet.addAll(matchTransition.label());
                }
                if (matchSet.getIntervals().size() == 1) {
                    if (matchSet.size() == 1) {
                        newTransition = new AtomTransition(blockEndState, matchSet.getMinElement());
                    } else {
                        Interval matchInterval = matchSet.getIntervals().get(0);
                        newTransition = new RangeTransition(blockEndState, matchInterval.a, matchInterval.b);
                    }
                } else {
                    newTransition = new SetTransition(blockEndState, matchSet);
                }
                decision.transition((int)interval.a).target.setTransition(0, newTransition);
                for (int j = interval.a + 1; j <= interval.b; ++j) {
                    Transition removed = decision.removeTransition(interval.a + 1);
                    atn.removeState(removed.target);
                    ++removedStates;
                }
            }
        }
    }

    private static void optimizeStates(ATN atn) {
        List<ATNState> states = atn.states;
        int current = 0;
        for (int i = 0; i < states.size(); ++i) {
            ATNState state = states.get(i);
            if (state == null) continue;
            if (i != current) {
                state.stateNumber = current;
                states.set(current, state);
                states.set(i, null);
            }
            ++current;
        }
        states.subList(current, states.size()).clear();
    }

    private ATNOptimizer() {
    }
}

