/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.google.common.base.Objects;
import java.io.File;

@Immutable
public final class SourceFile {
    public static final SourceFile UNKNOWN = new SourceFile();
    @Nullable
    private final File mSourceFile;
    @Nullable
    private final String mDescription;

    public SourceFile(@NonNull File sourceFile, @NonNull String description) {
        this.mSourceFile = sourceFile;
        this.mDescription = description;
    }

    public SourceFile(@NonNull File sourceFile) {
        this.mSourceFile = sourceFile;
        this.mDescription = null;
    }

    public SourceFile(@NonNull String description) {
        this.mSourceFile = null;
        this.mDescription = description;
    }

    private SourceFile() {
        this.mSourceFile = null;
        this.mDescription = null;
    }

    @Nullable
    public File getSourceFile() {
        return this.mSourceFile;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourceFile)) {
            return false;
        }
        SourceFile other = (SourceFile)obj;
        return Objects.equal((Object)this.mDescription, (Object)other.mDescription) && Objects.equal((Object)this.mSourceFile, (Object)other.mSourceFile);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSourceFile, this.mDescription});
    }

    public String toString() {
        return this.print(false);
    }

    public String print(boolean shortFormat) {
        String fileDisplayName;
        if (this.mSourceFile == null) {
            if (this.mDescription == null) {
                return "Unknown source file";
            }
            return this.mDescription;
        }
        String fileName = this.mSourceFile.getName();
        String string = fileDisplayName = shortFormat ? fileName : this.mSourceFile.getAbsolutePath();
        if (this.mDescription == null || this.mDescription.equals(fileName)) {
            return fileDisplayName;
        }
        return String.format("[%1$s] %2$s", this.mDescription, fileDisplayName);
    }
}

