/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.LocalRepoLoader;
import com.android.repository.impl.manager.RemoteRepoLoader;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.io.FileOp;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.w3c.dom.ls.LSResourceResolver;

public class RepoManagerImpl
extends RepoManager {
    private final Set<SchemaModule> mModules = Sets.newHashSet();
    private FallbackLocalRepoLoader mFallbackLocalRepoLoader;
    private File mLocalPath;
    private FallbackRemoteRepoLoader mFallbackRemoteRepoLoader;
    private Set<RepositorySourceProvider> mSourceProviders = Sets.newHashSet();
    private RepositoryPackages mPackages = new RepositoryPackages();
    private long mLastRemoteRefreshMs;
    private long mLastLocalRefreshMs;
    private LoadTask mTask;
    private final Object mTaskLock = new Object();
    private final FileOp mFop;
    private final List<RepoManager.RepoLoadedCallback> mLocalListeners = Lists.newArrayList();
    private final List<RepoManager.RepoLoadedCallback> mRemoteListeners = Lists.newArrayList();

    public RepoManagerImpl(FileOp fop) {
        this.mFop = fop;
        this.registerSchemaModule(RepoManagerImpl.getCommonModule());
        this.registerSchemaModule(RepoManagerImpl.getGenericModule());
    }

    @Override
    public File getLocalPath() {
        return this.mLocalPath;
    }

    @Override
    public void setFallbackLocalRepoLoader(FallbackLocalRepoLoader fallback) {
        this.mFallbackLocalRepoLoader = fallback;
        this.markInvalid();
    }

    @Override
    public void setFallbackRemoteRepoLoader(FallbackRemoteRepoLoader remote) {
        this.mFallbackRemoteRepoLoader = remote;
        this.markInvalid();
    }

    @Override
    public void setLocalPath(File path) {
        this.mLocalPath = path;
        this.markInvalid();
    }

    @Override
    public void registerSourceProvider(RepositorySourceProvider provider) {
        this.mSourceProviders.add(provider);
        this.markInvalid();
    }

    @Override
    public Set<RepositorySourceProvider> getSourceProviders() {
        return this.mSourceProviders;
    }

    @Override
    public Set<RepositorySource> getSources(Downloader downloader, SettingsController settings, ProgressIndicator progress, boolean forceRefresh) {
        HashSet result = Sets.newHashSet();
        for (RepositorySourceProvider provider : this.mSourceProviders) {
            result.addAll(provider.getSources(downloader, settings, progress, forceRefresh));
        }
        return result;
    }

    @Override
    public Set<SchemaModule> getSchemaModules() {
        return this.mModules;
    }

    @Override
    public void registerSchemaModule(SchemaModule module) {
        this.mModules.add(module);
        this.markInvalid();
    }

    @Override
    public void markInvalid() {
        this.mLastRemoteRefreshMs = 0L;
        this.mLastLocalRefreshMs = 0L;
    }

    @Override
    public LSResourceResolver getResourceResolver(ProgressIndicator progress) {
        ImmutableList allModules = ImmutableList.builder().addAll(this.getSchemaModules()).add((Object)RepoManagerImpl.getCommonModule()).add((Object)RepoManagerImpl.getGenericModule()).build();
        return SchemaModuleUtil.createResourceResolver((Collection<SchemaModule>)allModules, progress);
    }

    @Override
    public RepositoryPackages getPackages() {
        return this.mPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(long cacheExpirationMs, List<RepoManager.RepoLoadedCallback> onLocalComplete, List<RepoManager.RepoLoadedCallback> onSuccess, List<Runnable> onError, ProgressRunner runner, Downloader downloader, SettingsController settings, boolean sync) {
        if (onLocalComplete == null) {
            onLocalComplete = ImmutableList.of();
        }
        if (onSuccess == null) {
            onSuccess = ImmutableList.of();
        }
        if (onError == null) {
            onError = ImmutableList.of();
        }
        if (this.checkExpiration(this.mLocalPath != null, downloader != null, cacheExpirationMs)) {
            for (RepoManager.RepoLoadedCallback localComplete : onLocalComplete) {
                runner.runSyncWithoutProgress(new CallbackRunnable(localComplete, this.mPackages));
            }
            Iterator iterator = onSuccess.iterator();
            while (iterator.hasNext()) {
                RepoManager.RepoLoadedCallback success = (RepoManager.RepoLoadedCallback)iterator.next();
                runner.runSyncWithoutProgress(new CallbackRunnable(success, this.mPackages));
            }
            return false;
        }
        final Semaphore completed = new Semaphore(1);
        try {
            completed.acquire();
        }
        catch (InterruptedException success) {
            // empty catch block
        }
        if (sync) {
            onSuccess = Lists.newArrayList((Iterable)onSuccess);
            onSuccess.add(new RepoManager.RepoLoadedCallback(){

                @Override
                public void doRun(RepositoryPackages packages) {
                    completed.release();
                }
            });
            onError = Lists.newArrayList((Iterable)onError);
            onError.add(new Runnable(){

                @Override
                public void run() {
                    completed.release();
                }
            });
        }
        boolean createdTask = false;
        try {
            Object object = this.mTaskLock;
            synchronized (object) {
                if (this.mTask != null) {
                    this.mTask.addCallbacks((List<RepoManager.RepoLoadedCallback>)onLocalComplete, (List<RepoManager.RepoLoadedCallback>)onSuccess, (List<Runnable>)onError, runner);
                } else {
                    this.mTask = new LoadTask((List<RepoManager.RepoLoadedCallback>)onLocalComplete, (List<RepoManager.RepoLoadedCallback>)onSuccess, (List<Runnable>)onError, downloader, settings);
                    createdTask = true;
                }
            }
            if (createdTask) {
                if (sync) {
                    runner.runSyncWithProgress(this.mTask);
                } else {
                    runner.runAsyncWithProgress(this.mTask);
                }
            } else if (sync) {
                try {
                    completed.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (createdTask) {
                this.mTask = null;
            }
        }
        return true;
    }

    private boolean checkExpiration(boolean checkLocal, boolean checkRemote, long timeoutPeriod) {
        long time = System.currentTimeMillis();
        return !(checkLocal && this.mLastLocalRefreshMs + timeoutPeriod <= time || checkRemote && this.mLastRemoteRefreshMs + timeoutPeriod <= time);
    }

    @Override
    public void registerLocalChangeListener(RepoManager.RepoLoadedCallback listener) {
        this.mLocalListeners.add(listener);
    }

    @Override
    public void registerRemoteChangeListener(RepoManager.RepoLoadedCallback listener) {
        this.mRemoteListeners.add(listener);
    }

    private static class CallbackRunnable
    implements Runnable {
        RepoManager.RepoLoadedCallback mCallback;
        RepositoryPackages mPackages;

        public CallbackRunnable(RepoManager.RepoLoadedCallback callback, RepositoryPackages packages) {
            this.mCallback = callback;
            this.mPackages = packages;
        }

        @Override
        public void run() {
            this.mCallback.doRun(this.mPackages);
        }
    }

    private class LoadTask
    implements ProgressRunner.ProgressRunnable {
        private final List<Callback> mOnSuccesses = Lists.newArrayList();
        private final List<Runnable> mOnErrors = Lists.newArrayList();
        private final List<Callback> mOnLocalCompletes = Lists.newArrayList();
        private final Downloader mDownloader;
        private final SettingsController mSettings;

        public LoadTask(List<RepoManager.RepoLoadedCallback> onLocalComplete, List<RepoManager.RepoLoadedCallback> onSuccess, List<Runnable> onError, Downloader downloader, SettingsController settings) {
            this.addCallbacks(onLocalComplete, onSuccess, onError, null);
            this.mDownloader = downloader;
            this.mSettings = settings;
        }

        public void addCallbacks(List<RepoManager.RepoLoadedCallback> onLocalComplete, List<RepoManager.RepoLoadedCallback> onSuccess, List<Runnable> onError, ProgressRunner runner) {
            for (RepoManager.RepoLoadedCallback local : onLocalComplete) {
                this.mOnLocalCompletes.add(new Callback(local, runner));
            }
            for (RepoManager.RepoLoadedCallback success : onSuccess) {
                this.mOnSuccesses.add(new Callback(success, runner));
            }
            this.mOnErrors.addAll(onError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(ProgressIndicator indicator, ProgressRunner runner) {
            Object object;
            boolean success;
            block68: {
                block66: {
                    block67: {
                        block64: {
                            block65: {
                                Object local;
                                block62: {
                                    block63: {
                                        success = false;
                                        if (RepoManagerImpl.this.mLocalPath != null) {
                                            if (RepoManagerImpl.this.mFallbackLocalRepoLoader != null) {
                                                RepoManagerImpl.this.mFallbackLocalRepoLoader.refresh();
                                            }
                                            local = new LocalRepoLoader(RepoManagerImpl.this.mLocalPath, RepoManagerImpl.this, RepoManagerImpl.this.mFallbackLocalRepoLoader, RepoManagerImpl.this.mFop);
                                            indicator.setText("Loading local repository...");
                                            Iterator<Object> newLocals = ((LocalRepoLoader)local).getPackages(indicator);
                                            boolean fireListeners = !newLocals.equals(RepoManagerImpl.this.mPackages.getLocalPackages());
                                            RepoManagerImpl.this.mPackages.setLocalPkgInfos((Map<String, ? extends LocalPackage>)((Object)newLocals));
                                            if (fireListeners) {
                                                for (RepoManager.RepoLoadedCallback listener : RepoManagerImpl.this.mLocalListeners) {
                                                    listener.doRun(RepoManagerImpl.this.mPackages);
                                                }
                                            }
                                            indicator.setFraction(0.25);
                                        }
                                        if (!indicator.isCanceled()) break block62;
                                        if (this.mDownloader == null) break block63;
                                        RepoManagerImpl.this.mLastRemoteRefreshMs = System.currentTimeMillis();
                                    }
                                    if (RepoManagerImpl.this.mLocalPath != null) {
                                        RepoManagerImpl.this.mLastLocalRefreshMs = System.currentTimeMillis();
                                    }
                                    local = RepoManagerImpl.this.mTaskLock;
                                    synchronized (local) {
                                        RepoManagerImpl.this.mTask = null;
                                        if (success) {
                                            for (Callback onLocalComplete : this.mOnLocalCompletes) {
                                                onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.mPackages));
                                            }
                                            for (Callback onSuccess : this.mOnSuccesses) {
                                                onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.mPackages));
                                            }
                                        } else {
                                            for (Runnable onError : this.mOnErrors) {
                                                onError.run();
                                            }
                                        }
                                    }
                                    return;
                                }
                                local = RepoManagerImpl.this.mTaskLock;
                                synchronized (local) {
                                    for (Callback onLocalComplete : this.mOnLocalCompletes) {
                                        onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.mCallback, RepoManagerImpl.this.mPackages));
                                    }
                                    this.mOnLocalCompletes.clear();
                                }
                                indicator.setText("Fetch remote repository...");
                                indicator.setSecondaryText("");
                                if (!RepoManagerImpl.this.mSourceProviders.isEmpty() && this.mDownloader != null) {
                                    RemoteRepoLoader remoteLoader = new RemoteRepoLoader(RepoManagerImpl.this.mSourceProviders, RepoManagerImpl.this.getResourceResolver(indicator), RepoManagerImpl.this.mFallbackRemoteRepoLoader);
                                    Map<String, RemotePackage> remotes = remoteLoader.fetchPackages(indicator, this.mDownloader, this.mSettings);
                                    indicator.setText("Computing updates...");
                                    indicator.setFraction(0.75);
                                    boolean fireListeners = !remotes.equals(RepoManagerImpl.this.mPackages.getRemotePackages());
                                    RepoManagerImpl.this.mPackages.setRemotePkgInfos(remotes);
                                    if (fireListeners) {
                                        for (RepoManager.RepoLoadedCallback callback : RepoManagerImpl.this.mRemoteListeners) {
                                            callback.doRun(RepoManagerImpl.this.mPackages);
                                        }
                                    }
                                }
                                if (!indicator.isCanceled()) break block64;
                                if (this.mDownloader == null) break block65;
                                RepoManagerImpl.this.mLastRemoteRefreshMs = System.currentTimeMillis();
                            }
                            if (RepoManagerImpl.this.mLocalPath != null) {
                                RepoManagerImpl.this.mLastLocalRefreshMs = System.currentTimeMillis();
                            }
                            object = RepoManagerImpl.this.mTaskLock;
                            synchronized (object) {
                                RepoManagerImpl.this.mTask = null;
                                if (success) {
                                    for (Callback onLocalComplete : this.mOnLocalCompletes) {
                                        onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.mPackages));
                                    }
                                    for (Callback onSuccess : this.mOnSuccesses) {
                                        onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.mPackages));
                                    }
                                } else {
                                    for (Runnable onError : this.mOnErrors) {
                                        onError.run();
                                    }
                                }
                            }
                            return;
                        }
                        indicator.setSecondaryText("");
                        indicator.setFraction(1.0);
                        if (!indicator.isCanceled()) break block66;
                        if (this.mDownloader == null) break block67;
                        RepoManagerImpl.this.mLastRemoteRefreshMs = System.currentTimeMillis();
                    }
                    if (RepoManagerImpl.this.mLocalPath != null) {
                        RepoManagerImpl.this.mLastLocalRefreshMs = System.currentTimeMillis();
                    }
                    object = RepoManagerImpl.this.mTaskLock;
                    synchronized (object) {
                        RepoManagerImpl.this.mTask = null;
                        if (success) {
                            for (Callback onLocalComplete : this.mOnLocalCompletes) {
                                onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.mPackages));
                            }
                            for (Callback onSuccess : this.mOnSuccesses) {
                                onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.mPackages));
                            }
                        } else {
                            for (Runnable onError : this.mOnErrors) {
                                onError.run();
                            }
                        }
                    }
                    return;
                }
                try {
                    success = true;
                    if (this.mDownloader == null) break block68;
                }
                catch (Throwable throwable) {
                    if (this.mDownloader != null) {
                        RepoManagerImpl.this.mLastRemoteRefreshMs = System.currentTimeMillis();
                    }
                    if (RepoManagerImpl.this.mLocalPath != null) {
                        RepoManagerImpl.this.mLastLocalRefreshMs = System.currentTimeMillis();
                    }
                    Object object2 = RepoManagerImpl.this.mTaskLock;
                    synchronized (object2) {
                        RepoManagerImpl.this.mTask = null;
                        if (success) {
                            for (Callback onLocalComplete : this.mOnLocalCompletes) {
                                onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.mPackages));
                            }
                            for (Callback onSuccess : this.mOnSuccesses) {
                                onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.mPackages));
                            }
                        } else {
                            for (Runnable onError : this.mOnErrors) {
                                onError.run();
                            }
                        }
                    }
                    throw throwable;
                }
                RepoManagerImpl.this.mLastRemoteRefreshMs = System.currentTimeMillis();
            }
            if (RepoManagerImpl.this.mLocalPath != null) {
                RepoManagerImpl.this.mLastLocalRefreshMs = System.currentTimeMillis();
            }
            object = RepoManagerImpl.this.mTaskLock;
            synchronized (object) {
                RepoManagerImpl.this.mTask = null;
                if (success) {
                    for (Callback onLocalComplete : this.mOnLocalCompletes) {
                        onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.mPackages));
                    }
                    for (Callback onSuccess : this.mOnSuccesses) {
                        onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.mPackages));
                    }
                } else {
                    for (Runnable onError : this.mOnErrors) {
                        onError.run();
                    }
                }
            }
        }

        private class Callback {
            private RepoManager.RepoLoadedCallback mCallback;
            private ProgressRunner mRunner;

            public Callback(RepoManager.RepoLoadedCallback callback, ProgressRunner runner) {
                this.mCallback = callback;
                this.mRunner = runner;
            }

            public ProgressRunner getRunner(ProgressRunner defaultRunner) {
                return this.mRunner == null ? defaultRunner : this.mRunner;
            }

            public RepoManager.RepoLoadedCallback getCallback() {
                return this.mCallback;
            }
        }
    }
}

