/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.model.SourceProvider;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Sync;

public class ProcessJavaResConfigAction
implements TaskConfigAction<Sync> {
    private VariantScope scope;

    public ProcessJavaResConfigAction(VariantScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("process", "JavaRes");
    }

    @Override
    public Class<Sync> getType() {
        return Sync.class;
    }

    @Override
    public void execute(Sync processResources) {
        AndroidSourceSet variantSourceSet;
        this.scope.getVariantData().processJavaResourcesTask = processResources;
        GradleVariantConfiguration variantConfiguration = this.scope.getVariantConfiguration();
        AndroidSourceSet defaultSourceSet = (AndroidSourceSet)variantConfiguration.getDefaultSourceSet();
        processResources.from(new Object[]{defaultSourceSet.getResources().getSourceFiles()});
        if (!variantConfiguration.getType().isSingleBuildType()) {
            AndroidSourceSet buildTypeSourceSet = (AndroidSourceSet)variantConfiguration.getBuildTypeSourceSet();
            Preconditions.checkState((buildTypeSourceSet != null ? 1 : 0) != 0);
            processResources.from(new Object[]{buildTypeSourceSet.getResources().getSourceFiles()});
        }
        if (variantConfiguration.hasFlavors()) {
            List flavorSourceProviders = variantConfiguration.getFlavorSourceProviders();
            for (SourceProvider flavorSourceProvider : flavorSourceProviders) {
                AndroidSourceSet flavorSourceSet = (AndroidSourceSet)flavorSourceProvider;
                processResources.from(new Object[]{flavorSourceSet.getResources().getSourceFiles()});
            }
            AndroidSourceSet multiFlavorSourceSet = (AndroidSourceSet)variantConfiguration.getMultiFlavorSourceProvider();
            if (multiFlavorSourceSet != null) {
                processResources.from(new Object[]{multiFlavorSourceSet.getResources().getSourceFiles()});
            }
        }
        if ((variantSourceSet = (AndroidSourceSet)variantConfiguration.getVariantSourceProvider()) != null) {
            processResources.from(new Object[]{variantSourceSet.getResources().getSourceFiles()});
        }
        if (processResources.getInputs().getFiles().getFiles().isEmpty()) {
            try {
                FileUtils.deleteFolder((File)this.scope.getSourceFoldersJavaResDestinationDir());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot delete merged source resource folder", e);
            }
        }
        ConventionMappingHelper.map((Task)processResources, "destinationDir", Callables.returning((Object)this.scope.getSourceFoldersJavaResDestinationDir()));
    }
}

