/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.builder.model.DimensionAware;
import com.android.builder.model.ProductFlavor;
import com.android.utils.StringHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Named;

public class ProductFlavorCombo<T extends DimensionAware & Named> {
    private String name;
    private final List<T> flavorList;

    public ProductFlavorCombo(T ... flavors) {
        this.flavorList = ImmutableList.copyOf((Object[])flavors);
    }

    public ProductFlavorCombo(Iterable<T> flavors) {
        this.flavorList = ImmutableList.copyOf(flavors);
    }

    public String getName() {
        if (this.name == null) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (DimensionAware flavor : this.flavorList) {
                if (first) {
                    sb.append(((Named)flavor).getName());
                    first = false;
                    continue;
                }
                sb.append(StringHelper.capitalize((String)((Named)flavor).getName()));
            }
            this.name = sb.toString();
        }
        return this.name;
    }

    public List<T> getFlavorList() {
        return this.flavorList;
    }

    public static String getFlavorComboName(List<? extends Named> flavorList) {
        Iterable flavorNames = Iterables.transform(flavorList, (Function)new Function<Named, String>(){

            public String apply(Named namedObject) {
                return namedObject.getName();
            }
        });
        return StringHelper.combineAsCamelCase((Iterable)flavorNames);
    }

    public static <S extends DimensionAware & Named> List<ProductFlavorCombo<S>> createCombinations(List<String> flavorDimensions, Iterable<S> productFlavors) {
        ArrayList result = Lists.newArrayList();
        if (flavorDimensions == null || flavorDimensions.isEmpty()) {
            for (DimensionAware flavor : productFlavors) {
                result.add(new ProductFlavorCombo(ImmutableList.of((Object)flavor)));
            }
        } else {
            ArrayListMultimap map = ArrayListMultimap.create();
            for (DimensionAware flavor : productFlavors) {
                String flavorDimension = flavor.getDimension();
                if (flavorDimension == null) {
                    throw new RuntimeException(String.format("Flavor '%1$s' has no flavor dimension.", ((Named)flavor).getName()));
                }
                if (!flavorDimensions.contains(flavorDimension)) {
                    throw new RuntimeException(String.format("Flavor '%1$s' has unknown dimension '%2$s'.", ((Named)flavor).getName(), flavor.getDimension()));
                }
                map.put((Object)flavorDimension, (Object)flavor);
            }
            ProductFlavorCombo.createProductFlavorCombinations(result, Lists.newArrayListWithCapacity((int)flavorDimensions.size()), 0, flavorDimensions, map);
        }
        return result;
    }

    private static ImmutableList<ProductFlavor> filterNullFromArray(ProductFlavor[] flavors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProductFlavor flavor : flavors) {
            if (flavor == null) continue;
            builder.add((Object)flavor);
        }
        return builder.build();
    }

    private static <S extends DimensionAware & Named> void createProductFlavorCombinations(List<ProductFlavorCombo<S>> flavorGroups, List<S> group, int index, List<String> flavorDimensionList, ListMultimap<String, S> map) {
        if (index == flavorDimensionList.size()) {
            flavorGroups.add(new ProductFlavorCombo(Iterables.filter(group, (Predicate)Predicates.notNull())));
            return;
        }
        String dimension = flavorDimensionList.get(index);
        List flavorList = map.get((Object)dimension);
        if (flavorList.isEmpty()) {
            throw new RuntimeException(String.format("No flavor is associated with flavor dimension '%1$s'.", dimension));
        }
        for (DimensionAware flavor : flavorList) {
            group.add(flavor);
            ProductFlavorCombo.createProductFlavorCombinations(flavorGroups, group, index + 1, flavorDimensionList, map);
            group.remove(group.size() - 1);
        }
    }
}

