/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import git4idea.GitPlatformFacade;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final Project myProject;

    public GitRepositoryManager(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (vcsRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRepositoryManager", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        super(vcsRepositoryManager, platformFacade.getVcs(project), ".git");
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
    }

    public boolean isSyncEnabled() {
        return this.myPlatformFacade.getSettings(this.myProject).getSyncSetting() == DvcsSyncSettings.Value.SYNC && !new GitMultiRootBranchConfig(this.getRepositories()).diverged();
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        List list = this.getRepositories(GitRepository.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "getRepositories"));
        }
        return list;
    }
}

