/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.spock;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.spock.SpockUtils;
import org.jetbrains.plugins.groovy.spock.SpockVariableDescriptor;

public class SpockUnrollReferenceProvider
extends PsiReferenceProvider {
    private static final Pattern PATTERN = Pattern.compile("\\#([\\w_]+)");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
        }
        GrAnnotationNameValuePair nvp = (GrAnnotationNameValuePair)element.getParent();
        String name = nvp.getName();
        if (name != null && !name.equals("value")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement argumentList = nvp.getParent();
        if (!(argumentList instanceof GrAnnotationArgumentList)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eAnnotation = argumentList.getParent();
        if (!(eAnnotation instanceof GrAnnotation)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrAnnotation annotation = (GrAnnotation)eAnnotation;
        String shortName = annotation.getShortName();
        if (!shortName.equals("Unroll") && !shortName.equals("spock.lang.Unroll")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement modifierList = annotation.getParent();
        if (!(modifierList instanceof GrModifierList)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eMethod = modifierList.getParent();
        if (!(eMethod instanceof GrMethod)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrMethod method = (GrMethod)eMethod;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange rangeInElement = manipulator.getRangeInElement(element);
        String text = rangeInElement.substring(element.getText());
        ArrayList<SpockVariableReference> references = new ArrayList<SpockVariableReference>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            TextRange range = new TextRange(rangeInElement.getStartOffset() + matcher.start(1), rangeInElement.getStartOffset() + matcher.end(1));
            references.add(new SpockVariableReference(element, range, references, method));
        }
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class SpockVariableReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myLeafElement;
        private final List<SpockVariableReference> myReferences;
        private final GrMethod myMethod;

        public SpockVariableReference(PsiElement element, TextRange range, List<SpockVariableReference> references, GrMethod method) {
            super(element, range);
            this.myReferences = references;
            this.myMethod = method;
            this.myLeafElement = element.getFirstChild();
        }

        public PsiElement resolve() {
            String value;
            Map<String, SpockVariableDescriptor> variableMap = SpockUtils.getVariableMap(this.myMethod);
            SpockVariableDescriptor descriptor = variableMap.get(value = this.getValue());
            if (descriptor == null) {
                return null;
            }
            return descriptor.getVariable();
        }

        @NotNull
        public Object[] getVariants() {
            Map<String, SpockVariableDescriptor> variableMap = SpockUtils.getVariableMap(this.myMethod);
            Object[] res = new Object[variableMap.size()];
            int i = 0;
            for (SpockVariableDescriptor descriptor : variableMap.values()) {
                res[i++] = descriptor.getVariable();
            }
            if (res == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/spock/SpockUnrollReferenceProvider$SpockVariableReference", "getVariants"));
            }
            return res;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            if (this.getElement().getFirstChild() != this.myLeafElement) {
                return this.getElement();
            }
            String oldValue = this.getValue();
            PsiElement res = null;
            int i = this.myReferences.size();
            while (--i >= 0) {
                SpockVariableReference reference = this.myReferences.get(i);
                if (!oldValue.equals(reference.getCanonicalText())) continue;
                res = reference.superHandleRename(newElementName);
            }
            return res;
        }

        public PsiElement superHandleRename(String newName) {
            return super.handleElementRename(newName);
        }
    }
}

