/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.TextUI;

public class SearchField
extends SearchTextField {
    public SearchField(boolean historyEnabled) {
        super(historyEnabled);
        this.updateTheme();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JTextField editor = this.getTextEditor();
        editor.setEnabled(enabled);
        this.updateBackground();
    }

    public void setUI(PanelUI ui) {
        super.setUI(ui);
        this.updateTheme();
    }

    private void updateTheme() {
        JTextField editor = this.getTextEditor();
        if (editor != null) {
            if (!SystemInfo.isMac) {
                editor.putClientProperty("JTextField.variant", "search");
                if (!(editor.getUI() instanceof DarculaTextFieldUI)) {
                    editor.setUI((TextUI)((DarculaTextFieldUI)DarculaTextFieldUI.createUI((JComponent)editor)));
                    editor.setBorder((Border)new DarculaTextBorder());
                }
            }
            this.updateBackground();
        }
    }

    private void updateBackground() {
        this.getTextEditor().setBackground(this.isEnabled() ? UIUtil.getTextFieldBackground() : UIUtil.getPanelBackground());
    }

    protected boolean isSearchControlUISupported() {
        return true;
    }
}

