/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.repository.Revision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalBuildToolPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public class RemoteBuildToolPkgInfo
extends RemotePkgInfo {
    private static final String INSTALL_ID_BASE = "build-tools-";

    public RemoteBuildToolPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newBuildTool((Revision)this.getRevision());
        pkgDescBuilder.setDescriptionShort(RemoteBuildToolPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteBuildToolPkgInfo.createListDescription(this.mListDisplay, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    @NotNull
    public String installId() {
        String string = this.getPkgDesc().getInstallId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/remote/internal/packages/RemoteBuildToolPkgInfo", "installId"));
        }
        return string;
    }

    private static String createListDescription(String listDisplay, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Build-Tools%1$s", obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, Revision revision, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Build-tools, revision %1$s%2$s", revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public boolean sameItemAs(LocalPkgInfo pkg, Revision.PreviewComparison comparePreview) {
        if (pkg instanceof LocalBuildToolPkgInfo) {
            LocalBuildToolPkgInfo rhs = (LocalBuildToolPkgInfo)pkg;
            return rhs.getDesc().getRevision().compareTo(this.getRevision(), comparePreview) == 0;
        }
        return false;
    }
}

