/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class GradleDslMethodCall
extends GradleDslExpression {
    @NotNull
    private final List<GradleDslElement> myArguments;
    @NotNull
    private final List<GradleDslElement> myToBeRemovedArguments;
    @Nullable
    private String myStatementName;
    private GradleDslExpressionMap myToBeAddedMapArgument;

    public GradleDslMethodCall(@NotNull GradleDslElement parent, @NotNull String methodName, @NotNull String statementName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "<init>"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "<init>"));
        }
        if (statementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementName", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "<init>"));
        }
        super(parent, null, methodName, null);
        this.myArguments = Lists.newArrayList();
        this.myToBeRemovedArguments = Lists.newArrayList();
        this.myStatementName = statementName;
    }

    public GradleDslMethodCall(@NotNull GradleDslElement parent, @NotNull GrMethodCallExpression methodCall, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "<init>"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "<init>"));
        }
        super(parent, (GroovyPsiElement)methodCall, name, (GrExpression)methodCall);
        this.myArguments = Lists.newArrayList();
        this.myToBeRemovedArguments = Lists.newArrayList();
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "addParsedExpression"));
        }
        expression.myParent = this;
        this.myArguments.add(expression);
    }

    public void addParsedExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        if (expressionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionMap", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "addParsedExpressionMap"));
        }
        expressionMap.myParent = this;
        this.myArguments.add(expressionMap);
    }

    public void addNewArgument(@NotNull GradleDslExpressionMap mapArgument) {
        if (mapArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapArgument", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "addNewArgument"));
        }
        if (this.getArguments().isEmpty()) {
            this.myToBeAddedMapArgument = mapArgument;
        }
    }

    @NotNull
    public List<GradleDslElement> getArguments() {
        if (this.myToBeRemovedArguments.isEmpty() && this.myToBeAddedMapArgument == null) {
            ImmutableList immutableList = ImmutableList.copyOf(this.myArguments);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "getArguments"));
            }
            return immutableList;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement argument : this.myArguments) {
            if (argument instanceof GradleDslReference) {
                GradleDslExpressionList listValue = ((GradleDslReference)argument).getValue(GradleDslExpressionList.class);
                if (listValue != null) {
                    result.addAll(listValue.getExpressions());
                    continue;
                }
                GradleDslExpressionMap mapValue = ((GradleDslReference)argument).getValue(GradleDslExpressionMap.class);
                if (mapValue != null) {
                    result.add(mapValue);
                    continue;
                }
            }
            result.add(argument);
        }
        if (this.myToBeAddedMapArgument != null) {
            result.add(this.myToBeAddedMapArgument);
        }
        for (GradleDslElement argument : this.myToBeRemovedArguments) {
            result.remove(argument);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "getArguments"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = this.getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "getChildren"));
        }
        return list;
    }

    @Override
    @Nullable
    public Object getValue() {
        GroovyPsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "getValue"));
        }
        Object value = this.getValue();
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Override
    public void setValue(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslMethodCall", "setValue"));
        }
    }

    public void remove(GradleDslElement argument) {
        if (this.myArguments.contains(argument)) {
            this.myToBeRemovedArguments.add(argument);
            this.setModified(true);
        }
    }

    @Override
    protected void apply() {
        for (GradleDslElement argument : this.myToBeRemovedArguments) {
            if (!this.myArguments.remove(argument)) continue;
            argument.delete();
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof GrMethodCallExpression) {
            GrMethodCallExpression methodCall = (GrMethodCallExpression)psiElement;
            if (this.myToBeAddedMapArgument != null) {
                this.myToBeAddedMapArgument.setPsiElement((GroovyPsiElement)methodCall.getArgumentList());
                this.myToBeAddedMapArgument.applyChanges();
                this.myArguments.add(this.myToBeAddedMapArgument);
            }
        }
        for (GradleDslElement argument : this.myArguments) {
            if (!argument.isModified()) continue;
            argument.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedMapArgument = null;
        this.myToBeRemovedArguments.clear();
        for (GradleDslElement argument : this.myArguments) {
            if (!argument.isModified()) continue;
            argument.resetState();
        }
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GrExpression[] expressionArguments;
        String statementText;
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        if (this.myParent == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrStatement statement = factory.createStatementFromText((CharSequence)(statementText = this.myStatementName + " " + this.myName + " ()"));
        PsiElement addedElement = parentPsiElement.addBefore((PsiElement)statement, parentPsiElement.getLastChild());
        if (addedElement instanceof GrApplicationStatement && (expressionArguments = ((GrApplicationStatement)addedElement).getArgumentList().getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrMethodCallExpression) {
            this.setPsiElement((GroovyPsiElement)expressionArguments[0]);
            return this.getPsiElement();
        }
        return null;
    }
}

