/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public class GradleDslElementList
extends GradleDslElement {
    @NotNull
    private final List<GradleDslElement> myElements;
    @NotNull
    private final List<GradleDslElement> myToBeAddedElements;
    @NotNull
    private final List<GradleDslElement> myToBeRemovedElements;

    public GradleDslElementList(@NotNull GradleDslElement parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "<init>"));
        }
        super(parent, null, name);
        this.myElements = Lists.newArrayList();
        this.myToBeAddedElements = Lists.newArrayList();
        this.myToBeRemovedElements = Lists.newArrayList();
    }

    public void addParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "addParsedElement"));
        }
        element.myParent = this;
        this.myElements.add(element);
    }

    public void addNewElement(@NotNull GradleDslElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "addNewElement"));
        }
        element.myParent = this;
        this.myToBeAddedElements.add(element);
        this.setModified(true);
    }

    public void removeElement(@NotNull GradleDslElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "removeElement"));
        }
        if (this.myElements.contains(element)) {
            this.myToBeRemovedElements.add(element);
            this.setModified(true);
        }
    }

    @NotNull
    public List<GradleDslElement> getElements() {
        if (this.myToBeAddedElements.isEmpty() && this.myToBeRemovedElements.isEmpty()) {
            ImmutableList immutableList = ImmutableList.copyOf(this.myElements);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "getElements"));
            }
            return immutableList;
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myElements);
        result.addAll(this.myToBeAddedElements);
        for (GradleDslElement element : this.myToBeRemovedElements) {
            result.remove(element);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "getElements"));
        }
        return arrayList;
    }

    @NotNull
    public <E extends GradleDslElement> List<E> getElements(Class<E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement element : this.getElements()) {
            if (!clazz.isInstance(element)) continue;
            result.add(clazz.cast(element));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "getElements"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public GroovyPsiElement getPsiElement() {
        return null;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        return this.myParent == null ? null : this.myParent.create();
    }

    @Override
    public void setPsiElement(@Nullable GroovyPsiElement psiElement) {
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ImmutableList immutableList = ImmutableList.copyOf(this.getElements());
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementList", "getChildren"));
        }
        return immutableList;
    }

    @Override
    protected void apply() {
        for (GradleDslElement element : this.myToBeAddedElements) {
            if (element.create() == null) continue;
            this.myElements.add(element);
        }
        this.myToBeAddedElements.clear();
        for (GradleDslElement element : this.myToBeRemovedElements) {
            if (!this.myElements.remove(element)) continue;
            element.delete();
        }
        this.myToBeRemovedElements.clear();
        for (GradleDslElement element : this.myElements) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedElements.clear();
        this.myToBeRemovedElements.clear();
        for (GradleDslElement element : this.myElements) {
            if (!element.isModified()) continue;
            element.resetState();
        }
    }
}

