/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.fd.InstantRunConfiguration;
import org.jetbrains.annotations.NotNull;

public class InstantRunSettings {
    public static final boolean SHOW_EXPERT_OPTIONS = Boolean.getBoolean("instant.run.expert.settings");

    public static boolean isInstantRunEnabled() {
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        return configuration.INSTANT_RUN;
    }

    public static boolean isShowToastEnabled() {
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        return configuration.SHOW_TOAST;
    }

    public static boolean isRestartActivity() {
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        return configuration.RESTART_ACTIVITY;
    }

    public static boolean isShowNotificationsEnabled() {
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        return configuration.SHOW_IR_STATUS_NOTIFICATIONS;
    }

    public static void setShowStatusNotifications(boolean en) {
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        configuration.SHOW_IR_STATUS_NOTIFICATIONS = en;
    }

    public static boolean isColdSwapEnabled() {
        if (!SHOW_EXPERT_OPTIONS) {
            return true;
        }
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        return configuration.COLD_SWAP;
    }

    @NotNull
    public static ColdSwapMode getColdSwapMode() {
        InstantRunConfiguration configuration = InstantRunConfiguration.getInstance();
        String value = configuration.COLD_SWAP_MODE;
        if (value == null) {
            ColdSwapMode coldSwapMode = ColdSwapMode.DEFAULT;
            if (coldSwapMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunSettings", "getColdSwapMode"));
            }
            return coldSwapMode;
        }
        ColdSwapMode coldSwapMode = ColdSwapMode.fromValue(value, ColdSwapMode.DEFAULT);
        if (coldSwapMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunSettings", "getColdSwapMode"));
        }
        return coldSwapMode;
    }

    public static enum ColdSwapMode {
        DEFAULT("Default", "default"),
        MULTI_APK("APK Splits", "multiapk"),
        MULTI_DEX("Multidex", "multidex"),
        NATIVE("Native", "native");

        public final String display;
        public final String value;

        private ColdSwapMode(String display, String value) {
            this.display = display;
            this.value = value;
        }

        @NotNull
        public static ColdSwapMode fromValue(@NotNull String v, @NotNull ColdSwapMode def) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "com/android/tools/idea/fd/InstantRunSettings$ColdSwapMode", "fromValue"));
            }
            if (def == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "def", "com/android/tools/idea/fd/InstantRunSettings$ColdSwapMode", "fromValue"));
            }
            for (ColdSwapMode mode : ColdSwapMode.values()) {
                if (!mode.value.equals(v)) continue;
                ColdSwapMode coldSwapMode = mode;
                if (coldSwapMode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunSettings$ColdSwapMode", "fromValue"));
                }
                return coldSwapMode;
            }
            ColdSwapMode coldSwapMode = def;
            if (coldSwapMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunSettings$ColdSwapMode", "fromValue"));
            }
            return coldSwapMode;
        }

        public String toString() {
            return this.display;
        }
    }
}

