/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.MainTreeNode;
import com.android.tools.idea.editors.allocations.nodes.PackageNode;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PackageRootNode
extends PackageNode
implements MainTreeNode {
    @NotNull
    private final Pattern myFilter;

    public PackageRootNode(@NotNull String name, @NotNull Pattern filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/allocations/nodes/PackageRootNode", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/editors/allocations/nodes/PackageRootNode", "<init>"));
        }
        super(name);
        this.myFilter = filter;
    }

    public PackageRootNode(@NotNull String name, @NotNull String filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/allocations/nodes/PackageRootNode", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/editors/allocations/nodes/PackageRootNode", "<init>"));
        }
        this(name, PackageRootNode.globToRegex(filter));
    }

    @Override
    public void insert(@NotNull AllocationInfo alloc) {
        String[] packages;
        if (alloc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alloc", "com/android/tools/idea/editors/allocations/nodes/PackageRootNode", "insert"));
        }
        StackTraceElement[] trace = alloc.getStackTrace();
        if (trace.length > 0) {
            String name;
            int ix;
            int match = 0;
            for (int i = 0; i < trace.length; ++i) {
                if (!this.myFilter.matcher(trace[i].getClassName()).matches()) continue;
                match = i;
                break;
            }
            name = (ix = (name = trace[match].getClassName()).indexOf("$")) >= 0 ? name.substring(0, ix) : name;
            packages = name.split("\\.");
        } else {
            packages = new String[]{"< Unknown >"};
        }
        this.insert(packages, alloc, 0);
    }

    static Pattern globToRegex(String glob) {
        String regex = "";
        int ix = glob.indexOf("*");
        while (ix != -1) {
            regex = regex + Pattern.quote(glob.substring(0, ix));
            regex = regex + ".*";
            glob = glob.substring(ix + 1);
            ix = glob.indexOf("*");
        }
        regex = regex + Pattern.quote(glob);
        return Pattern.compile(".*" + regex + ".*");
    }
}

