/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.DoubleProperty;
import com.android.tools.idea.ui.properties.core.DoubleValueProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableDouble;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.double_.DoubleExpression;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdDeviceData
implements Disposable {
    private StringProperty myName = new StringValueProperty();
    private OptionalProperty<IdDisplay> myDeviceType = new OptionalValueProperty<IdDisplay>();
    private StringProperty myManufacturer = new StringValueProperty();
    private DoubleProperty myDiagonalScreenSize = new DoubleValueProperty();
    private IntProperty myScreenResolutionWidth = new IntValueProperty();
    private IntProperty myScreenResolutionHeight = new IntValueProperty();
    private DoubleProperty myScreenDpi = new DoubleValueProperty();
    private ObjectProperty<Storage> myRamStorage = new ObjectValueProperty<Storage>(new Storage(0L, Storage.Unit.MiB));
    private BoolProperty myHasHardwareButtons = new BoolValueProperty();
    private BoolProperty myHasHardwareKeyboard = new BoolValueProperty();
    private OptionalProperty<Navigation> myNavigation = new OptionalValueProperty<Navigation>();
    private BoolProperty mySupportsLandscape = new BoolValueProperty();
    private BoolProperty mySupportsPortrait = new BoolValueProperty();
    private BoolProperty myHasBackCamera = new BoolValueProperty();
    private BoolProperty myHasFrontCamera = new BoolValueProperty();
    private BoolProperty myHasAccelerometer = new BoolValueProperty();
    private BoolProperty myHasGyroscope = new BoolValueProperty();
    private BoolProperty myHasGps = new BoolValueProperty();
    private BoolProperty myHasProximitySensor = new BoolValueProperty();
    private OptionalProperty<File> myCustomSkinFile = new OptionalValueProperty<File>();
    private BoolValueProperty myIsTv = new BoolValueProperty();
    private BoolValueProperty myIsWear = new BoolValueProperty();
    private BoolValueProperty myIsScreenRound = new BoolValueProperty();
    private IntValueProperty myScreenChinSize = new IntValueProperty();
    private OptionalProperty<Software> mySoftware = new OptionalValueProperty<Software>();
    private BindingsManager myBindings = new BindingsManager();

    public AvdDeviceData(@Nullable Device device, boolean forcedCreation) {
        Software software = new Software();
        software.setLiveWallpaperSupport(true);
        software.setGlVersion("2.0");
        this.mySoftware.setValue(software);
        this.myManufacturer.set("User");
        if (device == null) {
            this.initDefaultValues();
        } else {
            this.getValuesFromDevice(device, forcedCreation);
        }
        DoubleExpression dpiExpression = new DoubleExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myDiagonalScreenSize}){

            @Override
            @NotNull
            public Double get() {
                Double d = AvdScreenData.calculateDpi(((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue(), ((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue(), (Double)AvdDeviceData.this.myDiagonalScreenSize.get());
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData$1", "get"));
                }
                return d;
            }
        };
        this.myBindings.bind(this.myScreenDpi, dpiExpression);
    }

    private static String getUniqueId(@Nullable String id) {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getUniqueId(id);
    }

    public StringProperty name() {
        return this.myName;
    }

    public OptionalProperty<IdDisplay> deviceType() {
        return this.myDeviceType;
    }

    public StringProperty manufacturer() {
        return this.myManufacturer;
    }

    public DoubleProperty diagonalScreenSize() {
        return this.myDiagonalScreenSize;
    }

    public IntProperty screenResolutionWidth() {
        return this.myScreenResolutionWidth;
    }

    public IntProperty screenResolutionHeight() {
        return this.myScreenResolutionHeight;
    }

    public ObservableDouble screenDpi() {
        return this.myScreenDpi;
    }

    public ObjectProperty<Storage> ramStorage() {
        return this.myRamStorage;
    }

    public BoolProperty hasHardwareButtons() {
        return this.myHasHardwareButtons;
    }

    public BoolProperty hasHardwareKeyboard() {
        return this.myHasHardwareKeyboard;
    }

    public OptionalProperty<Navigation> navigation() {
        return this.myNavigation;
    }

    public BoolProperty supportsLandscape() {
        return this.mySupportsLandscape;
    }

    public BoolProperty supportsPortrait() {
        return this.mySupportsPortrait;
    }

    public BoolProperty hasFrontCamera() {
        return this.myHasFrontCamera;
    }

    public BoolProperty hasBackCamera() {
        return this.myHasBackCamera;
    }

    public BoolProperty hasAccelerometer() {
        return this.myHasAccelerometer;
    }

    public BoolProperty hasGyroscope() {
        return this.myHasGyroscope;
    }

    public BoolProperty hasGps() {
        return this.myHasGps;
    }

    public BoolProperty hasProximitySensor() {
        return this.myHasProximitySensor;
    }

    public OptionalProperty<Software> software() {
        return this.mySoftware;
    }

    public OptionalProperty<File> customSkinFile() {
        return this.myCustomSkinFile;
    }

    public BoolProperty isTv() {
        return this.myIsTv;
    }

    public BoolProperty isWear() {
        return this.myIsWear;
    }

    public BoolProperty isScreenRound() {
        return this.myIsScreenRound;
    }

    public IntProperty screenChinSize() {
        return this.myScreenChinSize;
    }

    private void initDefaultValues() {
        this.myName.set(AvdDeviceData.getUniqueId(null));
        this.myDiagonalScreenSize.set(5.0);
        this.myScreenResolutionWidth.set(1080);
        this.myScreenResolutionHeight.set(1920);
        this.myRamStorage.set(new Storage(2L, Storage.Unit.GiB));
        this.myHasHardwareButtons.set(false);
        this.myHasHardwareKeyboard.set(false);
        this.myNavigation.setValue(Navigation.NONAV);
        this.mySupportsPortrait.set(true);
        this.mySupportsLandscape.set(true);
        this.myHasFrontCamera.set(true);
        this.myHasBackCamera.set(true);
        this.myHasAccelerometer.set(true);
        this.myHasGyroscope.set(true);
        this.myHasGps.set(true);
        this.myHasProximitySensor.set(true);
    }

    private void getValuesFromDevice(Device device, boolean forceCreation) {
        this.myName.set(forceCreation ? AvdDeviceData.getUniqueId(device.getDisplayName() + " (Edited)") : device.getDisplayName());
        String tagId = device.getTagId();
        if (tagId != null) {
            for (IdDisplay tag : AvdWizardConstants.ALL_TAGS) {
                if (!tag.getId().equals(tagId)) continue;
                this.myDeviceType.setValue(tag);
                break;
            }
        }
        Hardware defaultHardware = device.getDefaultHardware();
        Screen screen = defaultHardware.getScreen();
        this.myDiagonalScreenSize.set(screen.getDiagonalLength());
        this.myScreenResolutionWidth.set(screen.getXDimension());
        this.myScreenResolutionHeight.set(screen.getYDimension());
        this.myRamStorage.set(AvdWizardConstants.getDefaultRam(defaultHardware));
        this.myHasHardwareButtons.set(defaultHardware.getButtonType() == ButtonType.HARD);
        this.myHasHardwareKeyboard.set(defaultHardware.getKeyboard() != Keyboard.NOKEY);
        this.myNavigation.setValue(defaultHardware.getNav());
        List states = device.getAllStates();
        for (State state : states) {
            if (state.getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                this.mySupportsPortrait.set(true);
            }
            if (!state.getOrientation().equals((Object)ScreenOrientation.LANDSCAPE)) continue;
            this.mySupportsLandscape.set(true);
        }
        this.myHasFrontCamera.set(defaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myHasBackCamera.set(defaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myHasAccelerometer.set(defaultHardware.getSensors().contains(Sensor.ACCELEROMETER));
        this.myHasGyroscope.set(defaultHardware.getSensors().contains(Sensor.GYROSCOPE));
        this.myHasGps.set(defaultHardware.getSensors().contains(Sensor.GPS));
        this.myHasProximitySensor.set(defaultHardware.getSensors().contains(Sensor.PROXIMITY_SENSOR));
        File skinFile = AvdEditWizard.resolveSkinPath(defaultHardware.getSkinFile(), null, FileOpUtils.create());
        this.myCustomSkinFile.setValue(skinFile == null ? AvdWizardConstants.NO_SKIN : skinFile);
        this.myIsTv.set(HardwareConfigHelper.isTv((Device)device));
        this.myIsWear.set(HardwareConfigHelper.isWear((Device)device));
        this.myIsScreenRound.set(device.isScreenRound());
        this.myScreenChinSize.set(device.getChinSize());
    }

    public void dispose() {
        this.myBindings.releaseAll();
    }
}

