/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.List;
import org.gradle.TaskExecutionRequest;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.tooling.internal.provider.PayloadClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelClassLoaderFactory
implements PayloadClassLoaderFactory {
    private final ClassLoader rootClassLoader;
    private final ClassLoaderFactory classLoaderFactory;

    public ModelClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
        ClassLoader parent = this.getClass().getClassLoader();
        FilteringClassLoader filter = new FilteringClassLoader(parent);
        filter.allowPackage("org.gradle.tooling.internal.protocol");
        filter.allowClass(TaskExecutionRequest.class);
        this.rootClassLoader = filter;
    }

    @Override
    public ClassLoader getClassLoaderFor(ClassLoaderSpec spec, List<? extends ClassLoader> parents) {
        if (spec.equals(ClassLoaderSpec.SYSTEM_CLASS_LOADER)) {
            return this.rootClassLoader;
        }
        return this.classLoaderFactory.createClassLoader(spec, parents);
    }
}

