/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.ImportFilteringUsageViewSetting;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.ImportFilteringRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ImportUsageFilteringRuleProvider
implements UsageFilteringRuleProvider {
    @Override
    @NotNull
    public UsageFilteringRule[] getActiveRules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/ImportUsageFilteringRuleProvider", "getActiveRules"));
        }
        ArrayList rules = new ArrayList();
        if (!ImportFilteringUsageViewSetting.getInstance().SHOW_IMPORTS) {
            ContainerUtil.addAll(rules, (Object[])Extensions.getExtensions(ImportFilteringRule.EP_NAME));
        }
        UsageFilteringRule[] usageFilteringRuleArray = rules.toArray(new UsageFilteringRule[rules.size()]);
        if (usageFilteringRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/ImportUsageFilteringRuleProvider", "getActiveRules"));
        }
        return usageFilteringRuleArray;
    }

    @Override
    @NotNull
    public AnAction[] createFilteringActions(@NotNull UsageView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/ImportUsageFilteringRuleProvider", "createFilteringActions"));
        }
        UsageViewImpl impl = (UsageViewImpl)view;
        if (view.getPresentation().isCodeUsages()) {
            JComponent component = view.getComponent();
            ShowImportsAction showImportsAction = new ShowImportsAction(impl);
            showImportsAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(73, 128)), component, view);
            AnAction[] anActionArray = new AnAction[]{showImportsAction};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/ImportUsageFilteringRuleProvider", "createFilteringActions"));
            }
            return anActionArray;
        }
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/ImportUsageFilteringRuleProvider", "createFilteringActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    private static class ShowImportsAction
    extends RuleAction {
        private ShowImportsAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.show.import.statements", new Object[0]), AllIcons.Actions.ShowImportStatements);
        }

        @Override
        protected boolean getOptionValue() {
            return ImportFilteringUsageViewSetting.getInstance().SHOW_IMPORTS;
        }

        @Override
        protected void setOptionValue(boolean value) {
            ImportFilteringUsageViewSetting.getInstance().SHOW_IMPORTS = value;
        }
    }
}

