/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ExternalAnnotatorsFilter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalLanguageAnnotators
extends LanguageExtension<ExternalAnnotator> {
    public static final ExternalLanguageAnnotators INSTANCE = new ExternalLanguageAnnotators();

    private ExternalLanguageAnnotators() {
        super("com.intellij.externalAnnotator");
    }

    @NotNull
    public static List<ExternalAnnotator> allForFile(@NotNull Language language, final @NotNull PsiFile file) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/ExternalLanguageAnnotators", "allForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ExternalLanguageAnnotators", "allForFile"));
        }
        List annotators = INSTANCE.allForLanguage(language);
        final ExternalAnnotatorsFilter[] filters = (ExternalAnnotatorsFilter[])Extensions.getExtensions(ExternalAnnotatorsFilter.EXTENSION_POINT_NAME);
        List list = ContainerUtil.findAll(annotators, (Condition)new Condition<ExternalAnnotator>(){

            public boolean value(ExternalAnnotator annotator) {
                for (ExternalAnnotatorsFilter filter : filters) {
                    if (!filter.isProhibited(annotator, file)) continue;
                    return false;
                }
                return true;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ExternalLanguageAnnotators", "allForFile"));
        }
        return list;
    }
}

