/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.ide.diff.DiffErrorElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.awt.Window;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffElement<T> {
    public static final DiffElement[] EMPTY_ARRAY = new DiffElement[0];
    public static final DiffElement ERROR_NODE = new DiffErrorElement("Can't load elements", "An error has been occurred while getting children");
    private DiffPanel myDiffPanel;
    private Editor myEditor;
    private static final Logger LOG = Logger.getInstance((String)DiffElement.class.getName());

    public abstract String getPath();

    @NotNull
    public abstract String getName();

    public String getPresentablePath() {
        return this.getName();
    }

    public abstract long getSize();

    public abstract long getTimeStamp();

    public FileType getFileType() {
        return FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
    }

    public abstract boolean isContainer();

    public abstract DiffElement[] getChildren() throws IOException;

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor(@Nullable Project project) {
        return null;
    }

    @Nullable
    public abstract byte[] getContent() throws IOException;

    @NotNull
    public Charset getCharset() {
        Charset charset = EncodingManager.getInstance().getDefaultCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/diff/DiffElement", "getCharset"));
        }
        return charset;
    }

    @Nullable
    public JComponent getViewComponent(Project project, @Nullable DiffElement target, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ide/diff/DiffElement", "getViewComponent"));
        }
        this.disposeViewComponent();
        try {
            FileType fileType = this.getFileType();
            if (fileType != null && fileType.isBinary()) {
                return this.getFromProviders(project, target);
            }
            byte[] content = this.getContent();
            this.myEditor = this.createViewComponentEditor(project, content, fileType);
            return this.myEditor != null ? this.myEditor.getComponent() : null;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Editor createViewComponentEditor(Project project, @Nullable byte[] content, @Nullable FileType fileType) {
        Document document;
        EditorFactory editorFactory = EditorFactory.getInstance();
        if (editorFactory == null) {
            return null;
        }
        T value = this.getValue();
        Document document2 = document = value instanceof VirtualFile ? FileDocumentManager.getInstance().getDocument((VirtualFile)value) : editorFactory.createDocument(StringUtil.convertLineSeparators((String)new String(content)));
        if (document != null && fileType != null) {
            return editorFactory.createEditor(document, project, fileType, true);
        }
        return null;
    }

    @Nullable
    protected JComponent getFromProviders(Project project, DiffElement target) {
        return null;
    }

    @Nullable
    public JComponent getDiffComponent(DiffElement element, Project project, Window parentWindow, Disposable disposableParent) throws FilesTooBigForDiffException {
        DiffRequest request;
        this.disposeDiffComponent();
        try {
            request = this.createRequest(project, element);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (request != null) {
            this.myDiffPanel = DiffManager.getInstance().createDiffPanel(parentWindow, project, disposableParent, null);
            this.myDiffPanel.setRequestFocus(false);
            this.myDiffPanel.setDiffRequest(request);
            this.myDiffPanel.setTitle1(this.getName());
            this.myDiffPanel.setTitle2(element.getName());
            return this.myDiffPanel.getComponent();
        }
        return null;
    }

    @Nullable
    protected DiffRequest createRequest(Project project, DiffElement element) throws IOException {
        T src = this.getValue();
        T trg = element.getValue();
        if (src instanceof VirtualFile && trg instanceof VirtualFile && ((VirtualFile)src).getFileType().isBinary() && ((VirtualFile)trg).getFileType().isBinary()) {
            return this.createRequestForBinaries(project, (VirtualFile)src, (VirtualFile)trg);
        }
        if (src instanceof VirtualFile) {
            if (((VirtualFile)src).getFileType().isBinary()) {
                return null;
            }
            if (trg instanceof VirtualFile) {
                if (((VirtualFile)trg).getFileType().isBinary()) {
                    return null;
                }
                FileDocumentManager mgr = FileDocumentManager.getInstance();
                if (mgr.getDocument((VirtualFile)src) != null && mgr.getDocument((VirtualFile)trg) != null) {
                    return SimpleDiffRequest.compareFiles((VirtualFile)src, (VirtualFile)trg, project == null ? ProjectManager.getInstance().getDefaultProject() : project);
                }
            }
        }
        DiffContent srcContent = this.createDiffContent();
        DiffContent trgContent = element.createDiffContent();
        if (srcContent != null && trgContent != null) {
            SimpleDiffRequest request = new SimpleDiffRequest(project, "");
            request.setContents(srcContent, trgContent);
            return request;
        }
        return null;
    }

    @Nullable
    protected DiffRequest createRequestForBinaries(Project project, @NotNull VirtualFile src, @NotNull VirtualFile trg) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/ide/diff/DiffElement", "createRequestForBinaries"));
        }
        if (trg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trg", "com/intellij/ide/diff/DiffElement", "createRequestForBinaries"));
        }
        return SimpleDiffRequest.compareFiles(src, trg, project);
    }

    @Nullable
    protected DiffContent createDiffContent() throws IOException {
        return new SimpleContent(new String(this.getContent(), this.getCharset()), this.getFileType());
    }

    public abstract T getValue();

    public void disposeViewComponent() {
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myEditor = null;
        }
    }

    public void disposeDiffComponent() {
        if (this.myDiffPanel != null) {
            Disposer.dispose((Disposable)this.myDiffPanel);
            this.myDiffPanel = null;
        }
    }

    public String getSeparator() {
        return "/";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public Callable<DiffElement<T>> getElementChooser(Project project) {
        return null;
    }

    @Nullable
    public DataProvider getDataProvider(Project project) {
        return null;
    }

    public boolean isOperationsEnabled() {
        return false;
    }

    @Nullable
    public DiffElement<?> copyTo(DiffElement<T> container, String relativePath) {
        return null;
    }

    public boolean delete() {
        return false;
    }

    public void refresh(boolean userInitiated) throws IOException {
    }
}

