/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.InvertedRenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedDependencyEdge
implements DependencyEdge {
    private final ResolvedDependencyResult dependency;

    public ResolvedDependencyEdge(ResolvedDependencyResult dependency) {
        this.dependency = dependency;
    }

    @Override
    public boolean isResolvable() {
        return true;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependency.getRequested();
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.dependency.getSelected().getSelectionReason();
    }

    @Override
    public ComponentIdentifier getActual() {
        return this.dependency.getSelected().getId();
    }

    @Override
    public ComponentIdentifier getFrom() {
        return this.dependency.getFrom().getId();
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return Collections.singleton(new InvertedRenderableModuleResult(this.dependency.getFrom()));
    }
}

