/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class AddNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String message;
    private String notesRef = "refs/notes/commits";

    protected AddNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            RevWalk walk = new RevWalk(this.repo);
            try {
                ObjectInserter inserter = this.repo.newObjectInserter();
                try {
                    Ref ref = this.repo.getRef(this.notesRef);
                    if (ref != null) {
                        notesCommit = walk.parseCommit(ref.getObjectId());
                        map = NoteMap.read(walk.getObjectReader(), notesCommit);
                    }
                    map.set(this.id, this.message, inserter);
                    this.commitNoteMap(walk, map, notesCommit, inserter, "Notes added by 'git notes add'");
                    Note note = map.getNote(this.id);
                    inserter.close();
                    return note;
                }
                catch (Throwable throwable) {
                    inserter.close();
                    throw throwable;
                }
            }
            finally {
                walk.close();
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public AddNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public AddNoteCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    private void commitNoteMap(RevWalk walk, NoteMap map, RevCommit notesCommit, ObjectInserter inserter, String msg) throws IOException {
        CommitBuilder builder = new CommitBuilder();
        builder.setTreeId(map.writeTree(inserter));
        builder.setAuthor(new PersonIdent(this.repo));
        builder.setCommitter(builder.getAuthor());
        builder.setMessage(msg);
        if (notesCommit != null) {
            builder.setParentIds(notesCommit);
        }
        ObjectId commit = inserter.insert(builder);
        inserter.flush();
        RefUpdate refUpdate = this.repo.updateRef(this.notesRef);
        if (notesCommit != null) {
            refUpdate.setExpectedOldObjectId(notesCommit);
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.setNewObjectId(commit);
        refUpdate.update(walk);
    }

    public AddNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

