/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.SettableValue;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.android.utils.HtmlBuilder;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gct.studio.samples.SampleImportTreeManager;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.samples.SamplePreviewPanel;
import com.google.gct.studio.samples.SampleSetupStep;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class SampleBrowserStep
extends ModelWizardStep<SampleModel> {
    private final SampleCollection mySampleList;
    private final SampleSetupStep mySampleSetupStep;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private final BindingsManager myBindings;
    private Tree mySampleTree;
    private SampleImportTreeManager mySampleTreeManager;
    private JPanel myPanel;
    private JEditorPane myDescriptionPane;
    private SearchTextField mySearchBox;
    private SamplePreviewPanel mySamplePreviewPanel;
    private JBScrollPane mySamplePreviewScrollPanel;
    private JPanel myDescriptionPanel;

    public SampleBrowserStep(@NotNull SampleModel model, @NotNull SampleCollection sampleList) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/google/gct/studio/samples/SampleBrowserStep", "<init>"));
        }
        if (sampleList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleList", "com/google/gct/studio/samples/SampleBrowserStep", "<init>"));
        }
        super((WizardModel)model, GctStudioBundle.message("sample.browser.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myBindings = new BindingsManager();
        this.mySampleList = sampleList;
        this.mySampleTreeManager = new SampleImportTreeManager(this.mySampleTree, this.mySampleList);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, this.myPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, GctStudioBundle.message("sample.browser.description", new Object[0]));
        this.mySampleSetupStep = new SampleSetupStep(model);
        this.myDescriptionPane = SwingHelper.createHtmlViewer((boolean)false, null, null, null);
        this.myDescriptionPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myDescriptionPanel.add(this.myDescriptionPane);
        this.mySamplePreviewScrollPanel.getVerticalScrollBar().setUnitIncrement(16);
    }

    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleBrowserStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    public JComponent getPreferredFocusComponent() {
        return this.mySearchBox;
    }

    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList arrayList = Lists.newArrayList((Object[])new SampleSetupStep[]{this.mySampleSetupStep});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleBrowserStep", "createDependentSteps"));
        }
        return arrayList;
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/google/gct/studio/samples/SampleBrowserStep", "onWizardStarting"));
        }
        final OptionalProperty<Sample> sample = ((SampleModel)this.getModel()).sample();
        sample.setNullableValue((Object)this.mySampleTreeManager.getSelectedSample());
        this.mySampleTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                sample.setNullableValue((Object)SampleBrowserStep.this.mySampleTreeManager.getSelectedSample());
            }
        });
        this.myListeners.listenAndFire(sample, new InvalidationListener(){

            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/gct/studio/samples/SampleBrowserStep$2", "onInvalidated"));
                }
                Sample sampleValue = (Sample)sample.getValueOrNull();
                SampleBrowserStep.this.mySamplePreviewPanel.setSample(sampleValue);
                SampleBrowserStep.this.mySampleSetupStep.setUrl(sampleValue != null ? sampleValue.getCloneUrl() : "");
            }
        });
        StringValueProperty htmlDesc = new StringValueProperty();
        this.myBindings.bind((SettableValue)htmlDesc, (ObservableValue)new TransformOptionalExpression<Sample, String>("", sample){

            @NotNull
            protected String transform(@NotNull Sample sample) {
                if (sample == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/google/gct/studio/samples/SampleBrowserStep$3", "transform"));
                }
                HtmlBuilder description = new HtmlBuilder();
                if (sample.getDescription() != null) {
                    description.addHtml(sample.getDescription());
                } else {
                    description.add(GctStudioBundle.message("sample.browser.no.description", new Object[0]));
                }
                description.newlineIfNecessary().newline();
                description.add("Tags: ");
                description.add(StringUtil.join((Collection)sample.getCategories(), (String)","));
                description.newlineIfNecessary().newline();
                StringBuilder urlBuilder = new StringBuilder();
                String cloneUrl = sample.getCloneUrl();
                String path = sample.getPath();
                urlBuilder.append(cloneUrl);
                if (!Strings.isNullOrEmpty((String)path)) {
                    urlBuilder.append(cloneUrl.endsWith("/") ? "" : "/");
                    urlBuilder.append("tree/master/");
                    urlBuilder.append(SampleModel.trimSlashes(path));
                }
                description.addLink(GctStudioBundle.message("sample.browse.source", new Object[0]), urlBuilder.toString());
                String string = description.getHtml();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleBrowserStep$3", "transform"));
                }
                return string;
            }
        });
        this.myListeners.listenAndFire((ObservableValue)htmlDesc, new InvalidationListener((StringProperty)htmlDesc){
            final /* synthetic */ StringProperty val$htmlDesc;
            {
                this.val$htmlDesc = stringProperty;
            }

            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/gct/studio/samples/SampleBrowserStep$4", "onInvalidated"));
                }
                SwingHelper.setHtml((JEditorPane)SampleBrowserStep.this.myDescriptionPane, (String)((String)this.val$htmlDesc.get()), (Color)UIUtil.getLabelForeground());
            }
        });
        TextProperty searchValue = new TextProperty((JTextComponent)this.mySearchBox.getTextEditor());
        this.myListeners.listenAndFire((ObservableValue)searchValue, (Consumer)new Consumer<String>(){

            public void consume(String keyword) {
                SampleBrowserStep.this.mySampleTreeManager.filterTree(keyword);
            }
        });
        this.myValidatorPanel.registerValidator(sample, (Validator)new Validator<Optional<Sample>>(){

            @NotNull
            public Validator.Result validate(@NotNull Optional<Sample> sample) {
                if (sample == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/google/gct/studio/samples/SampleBrowserStep$6", "validate"));
                }
                Validator.Result result = !sample.isPresent() ? new Validator.Result(Validator.Severity.ERROR, GctStudioBundle.message("sample.browser.please.select", new Object[0])) : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleBrowserStep$6", "validate"));
                }
                return result;
            }
        });
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleBrowserStep", "canGoForward"));
        }
        return observableBool;
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SamplePreviewPanel samplePreviewPanel;
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        Tree tree;
        SearchTextField searchTextField;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySearchBox = searchTextField = new SearchTextField();
        searchTextField.setToolTipText("Search by Name or Key Word");
        jPanel3.add((Component)searchTextField, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setEnabled(true);
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySampleTree = tree = new Tree();
        jBScrollPane2.setViewportView((Component)tree);
        this.mySamplePreviewScrollPanel = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jBScrollPane.setViewportView(jPanel4);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myDescriptionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jPanel, gridBagConstraints);
        this.mySamplePreviewPanel = samplePreviewPanel = new SamplePreviewPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        jPanel4.add((Component)samplePreviewPanel, gridBagConstraints2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

