/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GithubRepoContents {
    private static final long CACHE_TIMEOUT_MS = 3600000L;
    private File rootFolder;
    private List<File> sampleRoots;
    private String errorMessage;
    private boolean cancelled = false;

    @NotNull
    public static GithubRepoContents download(@NotNull Project project, @NotNull String url, @Nullable String branch, @Nullable File cacheDirectory) {
        URL parsedUrl;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/studio/samples/GithubRepoContents", "download"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/google/gct/studio/samples/GithubRepoContents", "download"));
        }
        GithubRepoContents returnValue = new GithubRepoContents();
        if (cacheDirectory == null) {
            cacheDirectory = new File(FileUtil.getTempDirectory(), "github_cache");
        }
        if (branch == null || branch.trim().isEmpty()) {
            branch = "master";
        }
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            returnValue.errorMessage = "Malformed URL";
            GithubRepoContents githubRepoContents = returnValue;
            if (githubRepoContents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/GithubRepoContents", "download"));
            }
            return githubRepoContents;
        }
        String repositoryName = "Github" + parsedUrl.getPath().replace('/', '-');
        final File outputFile = new File(cacheDirectory, repositoryName + ".zip");
        final String finalUrl = url + "/zipball/" + branch;
        File unzippedDir = new File(cacheDirectory, repositoryName);
        if (!unzippedDir.exists() || unzippedDir.lastModified() == 0L || System.currentTimeMillis() - unzippedDir.lastModified() > 3600000L) {
            block15: {
                GithubRepoContents githubRepoContents;
                FileUtil.delete((File)unzippedDir);
                try {
                    Outcome outcome = DownloadUtil.provideDataWithProgressSynchronously((Project)project, (String)"Downloading project from GitHub", (String)"Downloading zip archive${content-length} ...", (Callable)new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                            DownloadUtil.downloadAtomically((ProgressIndicator)progress, (String)finalUrl, (File)outputFile);
                            return outputFile;
                        }
                    }, null);
                    Exception e = outcome.getException();
                    if (e != null) {
                        throw e;
                    }
                    if (!outcome.isCancelled()) break block15;
                    returnValue.cancelled = true;
                    githubRepoContents = returnValue;
                }
                catch (Exception e) {
                    returnValue.errorMessage = "Could not download specified project from Github. Check the URL and branchname.\n\n" + e.getMessage();
                    GithubRepoContents githubRepoContents2 = returnValue;
                    if (githubRepoContents2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/GithubRepoContents", "download"));
                    }
                    return githubRepoContents2;
                }
                if (githubRepoContents == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/GithubRepoContents", "download"));
                }
                return githubRepoContents;
            }
            ZipUtil.unzip((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (File)unzippedDir, (File)outputFile, null, null, (boolean)true);
            outputFile.delete();
        }
        returnValue.rootFolder = unzippedDir;
        returnValue.sampleRoots = GithubRepoContents.findSamplesInDirectory(unzippedDir, true);
        GithubRepoContents githubRepoContents = returnValue;
        if (githubRepoContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/GithubRepoContents", "download"));
        }
        return githubRepoContents;
    }

    @NotNull
    private static List<File> findSamplesInDirectory(@NotNull File directory, boolean recursive) {
        File[] files;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/google/gct/studio/samples/GithubRepoContents", "findSamplesInDirectory"));
        }
        ArrayList samples = Lists.newArrayList();
        if (new File(directory, "build.gradle").exists() || new File(directory, "settings.gradle").exists()) {
            samples.add(directory);
        }
        if (recursive && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                samples.addAll(GithubRepoContents.findSamplesInDirectory(file, true));
            }
        }
        ArrayList arrayList = samples;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/GithubRepoContents", "findSamplesInDirectory"));
        }
        return arrayList;
    }

    private GithubRepoContents() {
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public List<File> getSampleRoots() {
        return this.sampleRoots;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

