/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.logging.ConsoleOutput;
import org.gradle.logging.internal.AnsiConsole;
import org.gradle.logging.internal.ColorMap;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.ConsoleBackedProgressRenderer;
import org.gradle.logging.internal.DefaultColorMap;
import org.gradle.logging.internal.DefaultStatusBarFormatter;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressLogEventGenerator;
import org.gradle.logging.internal.StreamBackedStandardOutputListener;
import org.gradle.logging.internal.StreamingStyledTextOutput;
import org.gradle.logging.internal.StyledTextOutputBackedRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class OutputEventRenderer
implements OutputEventListener,
LoggingConfigurer,
LoggingOutputInternal {
    private final ListenerBroadcast<OutputEventListener> stdOutAndErrorFormatters = new ListenerBroadcast(OutputEventListener.class);
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast(OutputEventListener.class);
    private final ListenerBroadcast<StandardOutputListener> stdoutListeners = new ListenerBroadcast(StandardOutputListener.class);
    private final ListenerBroadcast<StandardOutputListener> stderrListeners = new ListenerBroadcast(StandardOutputListener.class);
    private final Object lock = new Object();
    private final DefaultColorMap colourMap = new DefaultColorMap();
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private final Action<? super OutputEventRenderer> consoleConfigureAction;
    private OutputStream originalStdOut;
    private OutputStream originalStdErr;
    private StreamBackedStandardOutputListener stdOutListener;
    private StreamBackedStandardOutputListener stdErrListener;
    private ConsoleOutput consoleOutput;

    public OutputEventRenderer(Action<? super OutputEventRenderer> consoleConfigureAction) {
        OutputEventListener stdOutChain = this.onNonError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput((StandardOutputListener)this.stdoutListeners.getSource())), false));
        this.stdOutAndErrorFormatters.add((Object)stdOutChain);
        OutputEventListener stdErrChain = this.onError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput((StandardOutputListener)this.stderrListeners.getSource())), false));
        this.stdOutAndErrorFormatters.add((Object)stdErrChain);
        this.consoleConfigureAction = consoleConfigureAction;
    }

    public ColorMap getColourMap() {
        return this.colourMap;
    }

    public ConsoleOutput getConsoleOutput() {
        return this.consoleOutput;
    }

    public OutputStream getOriginalStdOut() {
        return this.originalStdOut;
    }

    public OutputStream getOriginalStdErr() {
        return this.originalStdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachProcessConsole(ConsoleOutput consoleOutput) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleOutput = consoleOutput;
            this.consoleConfigureAction.execute((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachAnsiConsole(OutputStream outputStream) {
        Object object = this.lock;
        synchronized (object) {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            AnsiConsole console = new AnsiConsole(writer, writer, this.colourMap, true);
            this.addConsole(console, true, true, (ConsoleMetaData)new FallbackConsoleMetaData());
        }
    }

    @Override
    public void attachSystemOutAndErr() {
        this.addStandardOutputListener();
        this.addStandardErrorListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStandardOutputListener() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdOut = System.out;
            if (this.stdOutListener != null) {
                this.stdoutListeners.remove((Object)this.stdOutListener);
            }
            this.stdOutListener = new StreamBackedStandardOutputListener(System.out);
            this.addStandardOutputListener(this.stdOutListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStandardErrorListener() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdErr = System.err;
            if (this.stdErrListener != null) {
                this.stderrListeners.remove((Object)this.stdErrListener);
            }
            this.stdErrListener = new StreamBackedStandardOutputListener(System.err);
            this.addStandardErrorListener(this.stdErrListener);
        }
    }

    public void removeStandardOutputAndError() {
        this.removeStandardOutputListener();
        this.removeStandardErrorListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStandardOutputListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdOutListener != null) {
                this.stdoutListeners.remove((Object)this.stdOutListener);
                this.stdOutListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStandardErrorListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdErrListener != null) {
                this.stderrListeners.remove((Object)this.stdErrListener);
                this.stdErrListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllOutputEventListeners() {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputEventRenderer addConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData) {
        ConsoleBackedProgressRenderer consoleChain = new ConsoleBackedProgressRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getMainArea()), true), console, new DefaultStatusBarFormatter(consoleMetaData));
        Object object = this.lock;
        synchronized (object) {
            if (stdout && stderr) {
                this.formatters.add((Object)consoleChain);
                this.removeStandardOutputAndError();
            } else if (stdout) {
                this.formatters.add((Object)this.onNonError(consoleChain));
                this.removeStandardOutputListener();
            } else {
                this.formatters.add((Object)this.onError(consoleChain));
                this.removeStandardErrorListener();
            }
            consoleChain.onOutput(new LogLevelChangeEvent(this.logLevel));
        }
        return this;
    }

    private OutputEventListener onError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() == LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    private OutputEventListener onNonError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() != LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.add((Object)listener);
        }
    }

    @Override
    public void addStandardOutputListener(OutputStream outputStream) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(outputStream));
    }

    @Override
    public void addStandardErrorListener(OutputStream outputStream) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.remove((Object)listener);
        }
    }

    @Override
    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOutput(OutputEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getLogLevel() != null && event.getLogLevel().compareTo(this.logLevel) < 0) {
                return;
            }
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
                LogLevel newLogLevel = changeEvent.getNewLogLevel();
                if (newLogLevel == this.logLevel) {
                    return;
                }
                this.logLevel = newLogLevel;
            }
            ((OutputEventListener)this.stdOutAndErrorFormatters.getSource()).onOutput(event);
            ((OutputEventListener)this.formatters.getSource()).onOutput(event);
        }
    }
}

