/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.io.PrintStream;
import java.util.List;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class WarningPrinter {
    private final PrintStream printStream;
    private final StringMatcher classFilter;
    private int warningCount;

    public WarningPrinter() {
        this(System.err);
    }

    public WarningPrinter(PrintStream printStream) {
        this.printStream = printStream;
        this.classFilter = null;
    }

    public WarningPrinter(PrintStream printStream, List classFilter) {
        this.printStream = printStream;
        this.classFilter = classFilter == null ? null : new ListParser(new ClassNameParser()).parse(classFilter);
    }

    public void print(String className, String warning) {
        if (this.accepts(className)) {
            this.print(warning);
        }
    }

    public boolean accepts(String className) {
        return this.classFilter == null || !this.classFilter.matches(className);
    }

    public void print(String className1, String className2, String warning) {
        if (this.accepts(className1, className2)) {
            this.print(warning);
        }
    }

    public boolean accepts(String className1, String className2) {
        return this.classFilter == null || !this.classFilter.matches(className1) && !this.classFilter.matches(className2);
    }

    private void print(String warning) {
        this.printStream.println(warning);
        ++this.warningCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }
}

