/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.DataInput;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMember;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.io.RuntimeDataInput;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class LibraryClassReader
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor {
    private static final LibraryField[] EMPTY_LIBRARY_FIELDS = new LibraryField[0];
    private static final LibraryMethod[] EMPTY_LIBRARY_METHODS = new LibraryMethod[0];
    private final RuntimeDataInput dataInput;
    private final boolean skipNonPublicClasses;
    private final boolean skipNonPublicClassMembers;
    private Constant[] constantPool;

    public LibraryClassReader(DataInput dataInput, boolean skipNonPublicClasses, boolean skipNonPublicClassMembers) {
        this.dataInput = new RuntimeDataInput(dataInput);
        this.skipNonPublicClasses = skipNonPublicClasses;
        this.skipNonPublicClassMembers = skipNonPublicClassMembers;
    }

    public void visitProgramClass(ProgramClass libraryClass) {
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        int u4magic = this.dataInput.readInt();
        ClassUtil.checkMagicNumber(u4magic);
        int u2minorVersion = this.dataInput.readUnsignedShort();
        int u2majorVersion = this.dataInput.readUnsignedShort();
        int u4version = ClassUtil.internalClassVersion(u2majorVersion, u2minorVersion);
        ClassUtil.checkVersionNumbers(u4version);
        int u2constantPoolCount = this.dataInput.readUnsignedShort();
        this.constantPool = new Constant[u2constantPoolCount];
        for (int index = 1; index < u2constantPoolCount; ++index) {
            Constant constant = this.createConstant();
            constant.accept(libraryClass, this);
            int tag = constant.getTag();
            if (tag == 7 || tag == 1) {
                this.constantPool[index] = constant;
            }
            if (tag != 5 && tag != 6) continue;
            ++index;
        }
        libraryClass.u2accessFlags = this.dataInput.readUnsignedShort();
        if (this.skipNonPublicClasses && AccessUtil.accessLevel(libraryClass.getAccessFlags()) < 3) {
            return;
        }
        int u2thisClass = this.dataInput.readUnsignedShort();
        int u2superClass = this.dataInput.readUnsignedShort();
        libraryClass.thisClassName = this.getClassName(u2thisClass);
        libraryClass.superClassName = u2superClass == 0 ? null : this.getClassName(u2superClass);
        int u2interfacesCount = this.dataInput.readUnsignedShort();
        libraryClass.interfaceNames = new String[u2interfacesCount];
        for (int index = 0; index < u2interfacesCount; ++index) {
            int u2interface = this.dataInput.readUnsignedShort();
            libraryClass.interfaceNames[index] = this.getClassName(u2interface);
        }
        int u2fieldsCount = this.dataInput.readUnsignedShort();
        LibraryField[] reusableFields = new LibraryField[u2fieldsCount];
        int visibleFieldsCount = 0;
        for (int index = 0; index < u2fieldsCount; ++index) {
            LibraryField field = new LibraryField();
            this.visitLibraryMember(libraryClass, field);
            if (AccessUtil.accessLevel(field.getAccessFlags()) < (this.skipNonPublicClassMembers ? 2 : 1)) continue;
            reusableFields[visibleFieldsCount++] = field;
        }
        if (visibleFieldsCount == 0) {
            libraryClass.fields = EMPTY_LIBRARY_FIELDS;
        } else {
            libraryClass.fields = new LibraryField[visibleFieldsCount];
            System.arraycopy(reusableFields, 0, libraryClass.fields, 0, visibleFieldsCount);
        }
        int u2methodsCount = this.dataInput.readUnsignedShort();
        LibraryMethod[] reusableMethods = new LibraryMethod[u2methodsCount];
        int visibleMethodsCount = 0;
        for (int index = 0; index < u2methodsCount; ++index) {
            LibraryMethod method = new LibraryMethod();
            this.visitLibraryMember(libraryClass, method);
            if (AccessUtil.accessLevel(method.getAccessFlags()) < (this.skipNonPublicClassMembers ? 2 : 1)) continue;
            reusableMethods[visibleMethodsCount++] = method;
        }
        if (visibleMethodsCount == 0) {
            libraryClass.methods = EMPTY_LIBRARY_METHODS;
        } else {
            libraryClass.methods = new LibraryMethod[visibleMethodsCount];
            System.arraycopy(reusableMethods, 0, libraryClass.methods, 0, visibleMethodsCount);
        }
        this.skipAttributes();
    }

    public void visitProgramMember(ProgramClass libraryClass, ProgramMember libraryMember) {
    }

    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        libraryMember.u2accessFlags = this.dataInput.readUnsignedShort();
        libraryMember.name = this.getString(this.dataInput.readUnsignedShort());
        libraryMember.descriptor = this.getString(this.dataInput.readUnsignedShort());
        this.skipAttributes();
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.dataInput.skipBytes(4);
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.dataInput.skipBytes(8);
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.dataInput.skipBytes(4);
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.dataInput.skipBytes(8);
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.dataInput.skipBytes(2);
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        int u2length = this.dataInput.readUnsignedShort();
        byte[] bytes = new byte[u2length];
        this.dataInput.readFully(bytes);
        utf8Constant.setBytes(bytes);
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.dataInput.skipBytes(4);
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.dataInput.skipBytes(3);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.dataInput.skipBytes(4);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.dataInput.skipBytes(2);
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.dataInput.skipBytes(4);
    }

    private String getClassName(int constantIndex) {
        ClassConstant classEntry = (ClassConstant)this.constantPool[constantIndex];
        return this.getString(classEntry.u2nameIndex);
    }

    private String getString(int constantIndex) {
        return ((Utf8Constant)this.constantPool[constantIndex]).getString();
    }

    private Constant createConstant() {
        int u1tag = this.dataInput.readUnsignedByte();
        switch (u1tag) {
            case 3: {
                return new IntegerConstant();
            }
            case 4: {
                return new FloatConstant();
            }
            case 5: {
                return new LongConstant();
            }
            case 6: {
                return new DoubleConstant();
            }
            case 8: {
                return new StringConstant();
            }
            case 1: {
                return new Utf8Constant();
            }
            case 18: {
                return new InvokeDynamicConstant();
            }
            case 15: {
                return new MethodHandleConstant();
            }
            case 9: {
                return new FieldrefConstant();
            }
            case 10: {
                return new MethodrefConstant();
            }
            case 11: {
                return new InterfaceMethodrefConstant();
            }
            case 7: {
                return new ClassConstant();
            }
            case 16: {
                return new MethodTypeConstant();
            }
            case 12: {
                return new NameAndTypeConstant();
            }
        }
        throw new RuntimeException("Unknown constant type [" + u1tag + "] in constant pool");
    }

    private void skipAttributes() {
        int u2attributesCount = this.dataInput.readUnsignedShort();
        for (int index = 0; index < u2attributesCount; ++index) {
            this.skipAttribute();
        }
    }

    private void skipAttribute() {
        this.dataInput.skipBytes(2);
        int u4attributeLength = this.dataInput.readInt();
        this.dataInput.skipBytes(u4attributeLength);
    }
}

